import { type ObjectRecordDiff } from '@/database-events/object-record-diff';

type Properties<T> = {
  updatedFields?: string[];
  before?: T;
  after?: T;
  diff?: Partial<ObjectRecordDiff<T>>;
};

export class ObjectRecordBaseEvent<T = object> {
  recordId: string;
  userId?: string;
  userWorkspaceId?: string;
  workspaceMemberId?: string;
  properties: Properties<T>;
}
