import {
  DateDisplayFormat,
  FieldMetadataType,
  NumberDataType,
  RelationType,
} from 'twenty-shared/types';

import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';
import { type AllStandardObjectFieldName } from 'src/engine/workspace-manager/twenty-standard-application/types/all-standard-object-field-name.type';
import {
  type CreateStandardFieldArgs,
  createStandardFieldFlatMetadata,
} from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-field-flat-metadata.util';
import { createStandardRelationFieldFlatMetadata } from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-relation-field-flat-metadata.util';
import { getTsVectorColumnExpressionFromFields } from 'src/engine/workspace-manager/utils/get-ts-vector-column-expression.util';
import {
  SEARCH_FIELDS_FOR_WORKSPACE_MEMBER,
  WorkspaceMemberNumberFormatEnum,
} from 'src/modules/workspace-member/standard-objects/workspace-member.workspace-entity';

export const buildWorkspaceMemberStandardFlatFieldMetadatas = ({
  now,
  objectName,
  workspaceId,
  standardObjectMetadataRelatedEntityIds,
  dependencyFlatEntityMaps,
  twentyStandardApplicationId,
}: Omit<
  CreateStandardFieldArgs<'workspaceMember', FieldMetadataType>,
  'context'
>): Record<
  AllStandardObjectFieldName<'workspaceMember'>,
  FlatFieldMetadata
> => ({
  id: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'id',
      type: FieldMetadataType.UUID,
      label: 'Id',
      description: 'Id',
      icon: 'Icon123',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'uuid',
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  createdAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'createdAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Creation date',
      description: 'Creation date',
      icon: 'IconCalendar',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'now',
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  updatedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'updatedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Last update',
      description: 'Last time the record was changed',
      icon: 'IconCalendarClock',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'now',
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  deletedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'deletedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Deleted at',
      description: 'Date when the record was deleted',
      icon: 'IconCalendarMinus',
      isSystem: true,
      isNullable: true,
      isUIReadOnly: true,
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  position: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'position',
      type: FieldMetadataType.POSITION,
      label: 'Position',
      description: 'Workspace member position',
      icon: 'IconHierarchy2',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 0,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  name: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'name',
      type: FieldMetadataType.FULL_NAME,
      label: 'Name',
      description: 'Workspace member name',
      icon: 'IconCircleUser',
      isNullable: false,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  colorScheme: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'colorScheme',
      type: FieldMetadataType.TEXT,
      label: 'Color Scheme',
      description: 'Preferred color scheme',
      icon: 'IconColorSwatch',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'System'",
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  locale: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'locale',
      type: FieldMetadataType.TEXT,
      label: 'Language',
      description: 'Preferred language',
      icon: 'IconLanguage',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'en'",
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  avatarUrl: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'avatarUrl',
      type: FieldMetadataType.TEXT,
      label: 'Avatar Url',
      description: 'Workspace member avatar',
      icon: 'IconFileUpload',
      isSystem: true,
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  userEmail: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'userEmail',
      type: FieldMetadataType.TEXT,
      label: 'User Email',
      description: 'Related user email address',
      icon: 'IconMail',
      isSystem: true,
      isNullable: true,
      isUIReadOnly: true,
      isUnique: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  calendarStartDay: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'calendarStartDay',
      type: FieldMetadataType.NUMBER,
      label: 'Start of the week',
      description: "User's preferred start day of the week",
      icon: 'IconCalendar',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 7,
      settings: {
        dataType: NumberDataType.INT,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  userId: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'userId',
      type: FieldMetadataType.UUID,
      label: 'User Id',
      description: 'Associated User Id',
      icon: 'IconCircleUsers',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  timeZone: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'timeZone',
      type: FieldMetadataType.TEXT,
      label: 'Time zone',
      description: 'User time zone',
      icon: 'IconTimezone',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'system'",
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  dateFormat: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'dateFormat',
      type: FieldMetadataType.SELECT,
      label: 'Date format',
      description: "User's preferred date format",
      icon: 'IconCalendarEvent',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'SYSTEM'",
      options: [
        {
          id: '20202020-4b6a-4a08-8506-09bd59ef118e',
          value: 'SYSTEM',
          label: 'System',
          position: 0,
          color: 'turquoise',
        },
        {
          id: '20202020-6981-4e21-bb11-43ac1081be04',
          value: 'MONTH_FIRST',
          label: 'Month First',
          position: 1,
          color: 'red',
        },
        {
          id: '20202020-bf56-4199-b013-27ee921d046d',
          value: 'DAY_FIRST',
          label: 'Day First',
          position: 2,
          color: 'purple',
        },
        {
          id: '20202020-fd23-47d3-b01d-0479c11e5a2d',
          value: 'YEAR_FIRST',
          label: 'Year First',
          position: 3,
          color: 'sky',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  timeFormat: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'timeFormat',
      type: FieldMetadataType.SELECT,
      label: 'Time format',
      description: "User's preferred time format",
      icon: 'IconClock2',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'SYSTEM'",
      options: [
        {
          id: '20202020-349f-4ff8-82be-3eb52e7ec5f5',
          value: 'SYSTEM',
          label: 'System',
          position: 0,
          color: 'sky',
        },
        {
          id: '20202020-592c-4e33-a457-f4dcde59a3fc',
          value: 'HOUR_24',
          label: '24HRS',
          position: 1,
          color: 'red',
        },
        {
          id: '20202020-151c-43c2-a463-5bc42e5ce434',
          value: 'HOUR_12',
          label: '12HRS',
          position: 2,
          color: 'purple',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  numberFormat: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'numberFormat',
      type: FieldMetadataType.SELECT,
      label: 'Number format',
      description: "User's preferred number format",
      icon: 'IconNumbers',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: `'${WorkspaceMemberNumberFormatEnum.SYSTEM}'`,
      options: [
        {
          id: '20202020-8b5b-4cee-8449-ca48d7c65c11',
          value: WorkspaceMemberNumberFormatEnum.SYSTEM,
          label: 'System',
          position: 0,
          color: 'turquoise',
        },
        {
          id: '20202020-657d-409b-9c2a-d8c3b8842859',
          value: WorkspaceMemberNumberFormatEnum.COMMAS_AND_DOT,
          label: 'Commas and dot',
          position: 1,
          color: 'blue',
        },
        {
          id: '20202020-8703-4475-a92b-42e631851d8b',
          value: WorkspaceMemberNumberFormatEnum.SPACES_AND_COMMA,
          label: 'Spaces and comma',
          position: 2,
          color: 'green',
        },
        {
          id: '20202020-2ea4-4b99-b72b-bebac01fd7db',
          value: WorkspaceMemberNumberFormatEnum.DOTS_AND_COMMA,
          label: 'Dots and comma',
          position: 3,
          color: 'orange',
        },
        {
          id: '20202020-9d07-4353-8ce9-d067d639abf5',
          value: WorkspaceMemberNumberFormatEnum.APOSTROPHE_AND_DOT,
          label: 'Apostrophe and dot',
          position: 4,
          color: 'purple',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  searchVector: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'searchVector',
      type: FieldMetadataType.TS_VECTOR,
      label: 'Search vector',
      description: 'Field used for full-text search',
      icon: 'IconUser',
      isSystem: true,
      isNullable: true,
      isUIReadOnly: true,
      settings: {
        generatedType: 'STORED',
        asExpression: getTsVectorColumnExpressionFromFields(
          SEARCH_FIELDS_FOR_WORKSPACE_MEMBER,
        ),
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  assignedTasks: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'assignedTasks',
      label: 'Assigned tasks',
      description: 'Tasks assigned to the workspace member',
      icon: 'IconCheckbox',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'task',
      targetFieldName: 'assignee',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  favorites: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'favorites',
      label: 'Favorites',
      description: 'Favorites linked to the workspace member',
      icon: 'IconHeart',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'favorite',
      targetFieldName: 'forWorkspaceMember',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  accountOwnerForCompanies: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'accountOwnerForCompanies',
      label: 'Account Owner For Companies',
      description: 'Account owner for companies',
      icon: 'IconBriefcase',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'company',
      targetFieldName: 'accountOwner',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  connectedAccounts: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'connectedAccounts',
      label: 'Connected accounts',
      description: 'Connected accounts',
      icon: 'IconAt',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'connectedAccount',
      targetFieldName: 'accountOwner',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  messageParticipants: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'messageParticipants',
      label: 'Message Participants',
      description: 'Message Participants',
      icon: 'IconUserCircle',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'messageParticipant',
      targetFieldName: 'workspaceMember',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  blocklist: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'blocklist',
      label: 'Blocklist',
      description: 'Blocklisted handles',
      icon: 'IconForbid2',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'blocklist',
      targetFieldName: 'workspaceMember',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  calendarEventParticipants: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'calendarEventParticipants',
      label: 'Calendar Event Participants',
      description: 'Calendar Event Participants',
      icon: 'IconCalendar',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'calendarEventParticipant',
      targetFieldName: 'workspaceMember',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  timelineActivities: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'timelineActivities',
      label: 'Events',
      description: 'Events linked to the workspace member',
      icon: 'IconTimelineEvent',
      isNullable: true,
      isUIReadOnly: true,
      targetObjectName: 'timelineActivity',
      targetFieldName: 'workspaceMember',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  ownedOpportunities: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'ownedOpportunities',
      label: 'Owned opportunities',
      description: 'Opportunities owned by the workspace member',
      icon: 'IconTargetArrow',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'opportunity',
      targetFieldName: 'owner',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  createdBy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'createdBy',
      type: FieldMetadataType.ACTOR,
      label: 'Created by',
      description: 'The creator of the record',
      icon: 'IconCreativeCommonsSa',
      isSystem: true,
      isUIReadOnly: true,
      isNullable: false,
      defaultValue: {
        source: "'MANUAL'",
        name: "'System'",
        workspaceMemberId: null,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  updatedBy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'updatedBy',
      type: FieldMetadataType.ACTOR,
      label: 'Updated by',
      description: 'The workspace member who last updated the record',
      icon: 'IconUserCircle',
      isSystem: true,
      isUIReadOnly: true,
      isNullable: false,
      defaultValue: {
        source: "'MANUAL'",
        name: "'System'",
        workspaceMemberId: null,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
});
