import {
  DateDisplayFormat,
  FieldMetadataType,
  RelationOnDeleteAction,
  RelationType,
} from 'twenty-shared/types';

import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';
import { type AllStandardObjectFieldName } from 'src/engine/workspace-manager/twenty-standard-application/types/all-standard-object-field-name.type';
import {
  type CreateStandardFieldArgs,
  createStandardFieldFlatMetadata,
} from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-field-flat-metadata.util';
import { createStandardRelationFieldFlatMetadata } from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-relation-field-flat-metadata.util';
import { getTsVectorColumnExpressionFromFields } from 'src/engine/workspace-manager/utils/get-ts-vector-column-expression.util';
import { SEARCH_FIELDS_FOR_MESSAGE_CHANNEL_MESSAGE_ASSOCIATION } from 'src/modules/messaging/common/standard-objects/message-channel-message-association.workspace-entity';
import { MessageDirection } from 'src/modules/messaging/common/enums/message-direction.enum';

export const buildMessageChannelMessageAssociationStandardFlatFieldMetadatas =
  ({
    now,
    objectName,
    workspaceId,
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
  }: Omit<
    CreateStandardFieldArgs<
      'messageChannelMessageAssociation',
      FieldMetadataType
    >,
    'context'
  >): Record<
    AllStandardObjectFieldName<'messageChannelMessageAssociation'>,
    FlatFieldMetadata
  > => ({
    id: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'id',
        type: FieldMetadataType.UUID,
        label: 'Id',
        description: 'Id',
        icon: 'Icon123',
        isSystem: true,
        isNullable: false,
        isUIReadOnly: true,
        defaultValue: 'uuid',
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    createdAt: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'createdAt',
        type: FieldMetadataType.DATE_TIME,
        label: 'Creation date',
        description: 'Creation date',
        icon: 'IconCalendar',
        isSystem: true,
        isNullable: false,
        isUIReadOnly: true,
        defaultValue: 'now',
        settings: { displayFormat: DateDisplayFormat.RELATIVE },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    updatedAt: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'updatedAt',
        type: FieldMetadataType.DATE_TIME,
        label: 'Last update',
        description: 'Last time the record was changed',
        icon: 'IconCalendarClock',
        isSystem: true,
        isNullable: false,
        isUIReadOnly: true,
        defaultValue: 'now',
        settings: { displayFormat: DateDisplayFormat.RELATIVE },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    deletedAt: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'deletedAt',
        type: FieldMetadataType.DATE_TIME,
        label: 'Deleted at',
        description: 'Date when the record was deleted',
        icon: 'IconCalendarMinus',
        isSystem: true,
        isNullable: true,
        isUIReadOnly: true,
        settings: { displayFormat: DateDisplayFormat.RELATIVE },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    createdBy: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'createdBy',
        type: FieldMetadataType.ACTOR,
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isSystem: true,
        isUIReadOnly: true,
        isNullable: false,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    updatedBy: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'updatedBy',
        type: FieldMetadataType.ACTOR,
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isSystem: true,
        isUIReadOnly: true,
        isNullable: false,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    position: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'position',
        type: FieldMetadataType.POSITION,
        label: 'Position',
        description: 'Message channel message association record position',
        icon: 'IconHierarchy2',
        isSystem: true,
        isNullable: false,
        defaultValue: 0,
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    searchVector: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'searchVector',
        type: FieldMetadataType.TS_VECTOR,
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isSystem: true,
        isNullable: true,
        settings: {
          generatedType: 'STORED',
          asExpression: getTsVectorColumnExpressionFromFields(
            SEARCH_FIELDS_FOR_MESSAGE_CHANNEL_MESSAGE_ASSOCIATION,
          ),
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    messageExternalId: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'messageExternalId',
        type: FieldMetadataType.TEXT,
        label: 'Message External Id',
        description: 'Message id from the messaging provider',
        icon: 'IconHash',
        isNullable: true,
        isUIReadOnly: true,
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    messageThreadExternalId: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'messageThreadExternalId',
        type: FieldMetadataType.TEXT,
        label: 'Thread External Id',
        description: 'Thread id from the messaging provider',
        icon: 'IconHash',
        isNullable: true,
        isUIReadOnly: true,
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    direction: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'direction',
        type: FieldMetadataType.SELECT,
        label: 'Direction',
        description: 'Message Direction',
        icon: 'IconDirection',
        isNullable: false,
        isUIReadOnly: true,
        defaultValue: `'${MessageDirection.INCOMING}'`,
        options: [
          {
            id: '20202020-3075-4e35-b6a1-27db444a4668',
            value: MessageDirection.INCOMING,
            label: 'Incoming',
            position: 0,
            color: 'green',
          },
          {
            id: '20202020-a15f-4512-9202-391a3c0bbed3',
            value: MessageDirection.OUTGOING,
            label: 'Outgoing',
            position: 1,
            color: 'blue',
          },
        ],
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    messageChannel: createStandardRelationFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        type: FieldMetadataType.RELATION,
        morphId: null,
        fieldName: 'messageChannel',
        label: 'Message Channel Id',
        description: 'Message Channel Id',
        icon: 'IconHash',
        isNullable: true,
        isUIReadOnly: true,
        targetObjectName: 'messageChannel',
        targetFieldName: 'messageChannelMessageAssociations',
        settings: {
          relationType: RelationType.MANY_TO_ONE,
          onDelete: RelationOnDeleteAction.CASCADE,
          joinColumnName: 'messageChannelId',
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    messageThread: createStandardRelationFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        type: FieldMetadataType.RELATION,
        morphId: null,
        fieldName: 'messageThread',
        label: 'Message Thread Id',
        description: 'Message Thread Id',
        icon: 'IconHash',
        isNullable: true,
        isUIReadOnly: true,
        targetObjectName: 'messageThread',
        targetFieldName: 'messageChannelMessageAssociations',
        settings: {
          relationType: RelationType.MANY_TO_ONE,
          onDelete: RelationOnDeleteAction.CASCADE,
          joinColumnName: 'messageThreadId',
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    message: createStandardRelationFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        type: FieldMetadataType.RELATION,
        morphId: null,
        fieldName: 'message',
        label: 'Message Id',
        description: 'Message Id',
        icon: 'IconHash',
        isNullable: true,
        isUIReadOnly: true,
        targetObjectName: 'message',
        targetFieldName: 'messageChannelMessageAssociations',
        settings: {
          relationType: RelationType.MANY_TO_ONE,
          onDelete: RelationOnDeleteAction.CASCADE,
          joinColumnName: 'messageId',
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    messageFolders: createStandardRelationFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        type: FieldMetadataType.RELATION,
        morphId: null,
        fieldName: 'messageFolders',
        label: 'Message Folders',
        description: 'Message Folders (supports multiple folders/labels)',
        icon: 'IconFolders',
        isNullable: true,
        isUIReadOnly: true,
        targetObjectName: 'messageChannelMessageAssociationMessageFolder',
        targetFieldName: 'messageChannelMessageAssociation',
        settings: {
          relationType: RelationType.ONE_TO_MANY,
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
  });
