import { FieldMetadataType } from 'twenty-shared/types';

import { type UniversalFlatFieldMetadata } from 'src/engine/workspace-manager/workspace-migration/universal-flat-entity/types/universal-flat-field-metadata.type';

type PartialSystemFlatFieldMetadata<
  T extends FieldMetadataType = FieldMetadataType,
> = Omit<
  UniversalFlatFieldMetadata<T>,
  | 'applicationUniversalIdentifier'
  | 'universalIdentifier'
  | 'objectMetadataUniversalIdentifier'
  | 'createdAt'
  | 'updatedAt'
>;

const PARTIAL_ID_FIELD = {
  type: FieldMetadataType.UUID,
  name: 'id',
  label: 'Id',
  icon: 'Icon123',
  description: 'Id',
  isNullable: false,
  isUnique: true,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: 'uuid',
  options: null,
  standardOverrides: null,
  morphId: null,
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.UUID>;

const PARTIAL_CREATED_AT_FIELD = {
  type: FieldMetadataType.DATE_TIME,
  name: 'createdAt',
  label: 'Creation date',
  icon: 'IconCalendar',
  description: 'Creation date',
  isNullable: false,
  isUnique: false,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: 'now',
  options: null,
  standardOverrides: null,
  morphId: null,
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.DATE_TIME>;

const PARTIAL_UPDATED_AT_FIELD = {
  type: FieldMetadataType.DATE_TIME,
  name: 'updatedAt',
  label: 'Last update',
  icon: 'IconCalendarClock',
  description: 'Last time the record was changed',
  isNullable: false,
  isUnique: false,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: 'now',
  options: null,
  standardOverrides: null,
  morphId: null,
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.DATE_TIME>;

const PARTIAL_DELETED_AT_FIELD = {
  type: FieldMetadataType.DATE_TIME,
  name: 'deletedAt',
  label: 'Deleted at',
  icon: 'IconCalendarClock',
  description: 'Deletion date',
  isNullable: true,
  isUnique: false,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: null,
  options: null,
  standardOverrides: null,
  morphId: null,
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.DATE_TIME>;

const PARTIAL_CREATED_BY_FIELD = {
  type: FieldMetadataType.ACTOR,
  name: 'createdBy',
  label: 'Created by',
  icon: 'IconCreativeCommonsSa',
  description: 'The creator of the record',
  isNullable: false,
  isUnique: false,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: { name: "''", source: "'MANUAL'" },
  options: null,
  standardOverrides: null,
  morphId: null,
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.ACTOR>;

const PARTIAL_UPDATED_BY_FIELD = {
  type: FieldMetadataType.ACTOR,
  name: 'updatedBy',
  label: 'Updated by',
  icon: 'IconUserCircle',
  description: 'The workspace member who last updated the record',
  isNullable: false,
  isUnique: false,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: { name: "''", source: "'MANUAL'" },
  options: null,
  standardOverrides: null,
  morphId: null,
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.ACTOR>;

const PARTIAL_POSITION_FIELD = {
  type: FieldMetadataType.POSITION,
  name: 'position',
  label: 'Position',
  icon: 'IconHierarchy2',
  description: 'Position',
  isNullable: false,
  isUnique: false,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: 0,
  options: null,
  standardOverrides: null,
  morphId: null,
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.POSITION>;

const PARTIAL_SEARCH_VECTOR_FIELD = {
  type: FieldMetadataType.TS_VECTOR,
  name: 'searchVector',
  label: 'Search vector',
  icon: 'IconSearch',
  description: 'Search vector',
  isNullable: true,
  isUnique: false,
  isActive: true,
  isCustom: false,
  isSystem: true,
  isUIReadOnly: true,
  isLabelSyncedWithName: false,
  defaultValue: null,
  options: null,
  standardOverrides: null,
  morphId: null,
  // universalSettings for searchVector is computed at runtime
  // based on the name field (getTsVectorColumnExpressionFromFields)
  universalSettings: null,
  relationTargetObjectMetadataUniversalIdentifier: null,
  relationTargetFieldMetadataUniversalIdentifier: null,
  viewFilterUniversalIdentifiers: [],
  viewFieldUniversalIdentifiers: [],
  kanbanAggregateOperationViewUniversalIdentifiers: [],
  calendarViewUniversalIdentifiers: [],
  mainGroupByFieldMetadataViewUniversalIdentifiers: [],
} as const satisfies PartialSystemFlatFieldMetadata<FieldMetadataType.TS_VECTOR>;

export const PARTIAL_SYSTEM_FLAT_FIELD_METADATAS = {
  id: PARTIAL_ID_FIELD,
  createdAt: PARTIAL_CREATED_AT_FIELD,
  updatedAt: PARTIAL_UPDATED_AT_FIELD,
  deletedAt: PARTIAL_DELETED_AT_FIELD,
  createdBy: PARTIAL_CREATED_BY_FIELD,
  updatedBy: PARTIAL_UPDATED_BY_FIELD,
  position: PARTIAL_POSITION_FIELD,
  searchVector: PARTIAL_SEARCH_VECTOR_FIELD,
} as const satisfies Record<string, PartialSystemFlatFieldMetadata>;
