import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const TIMELINEACTIVITY_FLAT_FIELDS_MOCK = {
  happensAt: getFlatFieldMetadataMock({
    id: 'f8bbe593-cc45-4509-ba5f-aff1b4ae78a9',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.DATE_TIME,
    name: 'happensAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-9526-4993-b339-c4318c4d39f0',
  }),
  name: getFlatFieldMetadataMock({
    id: '8271b048-89c8-4db9-ba49-e20d1e634cea',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.TEXT,
    name: 'name',
    label: 'Event name',
    defaultValue: "''",
    description: 'Event name',
    icon: 'IconAbc',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-7207-46e8-9dab-849505ae8497',
  }),
  properties: getFlatFieldMetadataMock({
    id: '5067203a-5fc0-47a7-8fb3-466e8edc8e82',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RAW_JSON,
    name: 'properties',
    label: 'Event details',
    defaultValue: null,
    description: 'Json value for event details',
    icon: 'IconListDetails',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-f142-4b04-b91b-6a2b4af3bf11',
  }),
  linkedRecordCachedName: getFlatFieldMetadataMock({
    id: '6192bb0a-dcff-4ce9-9373-6b3efd74def3',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.TEXT,
    name: 'linkedRecordCachedName',
    label: 'Linked Record cached name',
    defaultValue: "''",
    description: 'Cached record name',
    icon: 'IconAbc',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-cfdb-4bef-bbce-a29f41230934',
  }),
  linkedRecordId: getFlatFieldMetadataMock({
    id: '1a1b9069-0274-4d89-a189-6944ebd8afd5',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.UUID,
    name: 'linkedRecordId',
    label: 'Linked Record id',
    defaultValue: null,
    description: 'Linked Record id',
    icon: 'IconAbc',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-2e0e-48c0-b445-ee6c1e61687d',
  }),
  linkedObjectMetadataId: getFlatFieldMetadataMock({
    id: 'aa0a6096-ddd6-44b3-a8c1-ec4c1ec70c52',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.UUID,
    name: 'linkedObjectMetadataId',
    label: 'Linked Object Metadata Id',
    defaultValue: null,
    description: 'Linked Object Metadata Id',
    icon: 'IconAbc',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-c595-449d-9f89-562758c9ee69',
  }),
  id: getFlatFieldMetadataMock({
    id: 'e78264fa-48bc-46cd-afc1-c5f2b5eb9472',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: 'cb8b2800-2a6e-443c-b671-df51c8a8ccdc',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: 'cc7b974c-4cb3-4b61-821a-824b4764fc6b',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: '544fdd41-6418-43e4-a46a-086c2c55924d',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  workspaceMember: getFlatFieldMetadataMock({
    id: 'c8d9c315-034a-4ffd-a6b3-e6386092d0a8',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'workspaceMember',
    label: 'Workspace Member',
    defaultValue: null,
    description: 'Event workspace member',
    icon: 'IconCircleUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'workspaceMemberId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'b2172f26-093d-4c9f-86c3-f0bcfaf54ad6',
    relationTargetObjectMetadataId: '7d8264db-2b55-4b74-81ff-b7064ed43840',
    universalIdentifier: '20202020-af23-4479-9a30-868edc474b36',
  }),
  person: getFlatFieldMetadataMock({
    id: 'dbd02754-4bef-4149-b39d-54759983ab47',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'person',
    label: 'Person',
    defaultValue: null,
    description: 'Event person',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'personId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'b1457347-545b-4a42-9c68-bc655952229a',
    relationTargetObjectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    universalIdentifier: '20202020-c414-45b9-a60a-ac27aa96229f',
  }),
  company: getFlatFieldMetadataMock({
    id: 'fd8cabe5-7dc8-4d6a-8053-43434488b3e4',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'company',
    label: 'Company',
    defaultValue: null,
    description: 'Event company',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'companyId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'cc78390f-f570-4c2c-9f19-2a8fef67f4f6',
    relationTargetObjectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    universalIdentifier: '20202020-04ad-4221-a744-7a8278a5ce21',
  }),
  opportunity: getFlatFieldMetadataMock({
    id: '026cbaa7-860c-4ed4-b878-8d78849e6c28',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'opportunity',
    label: 'Opportunity',
    defaultValue: null,
    description: 'Event opportunity',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'opportunityId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '7826944b-3b21-4448-892e-5a2a68161313',
    relationTargetObjectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    universalIdentifier: '20202020-7664-4a35-a3df-580d389fd527',
  }),
  note: getFlatFieldMetadataMock({
    id: '2b9f1c90-9e35-4ccc-8d84-b42de31ef127',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'note',
    label: 'Note',
    defaultValue: null,
    description: 'Event note',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'noteId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '1207d260-db2c-41d4-bb09-34ea1188978f',
    relationTargetObjectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    universalIdentifier: '20202020-ec55-4135-8da5-3a20badc0156',
  }),
  task: getFlatFieldMetadataMock({
    id: '187eaeb8-62c8-4925-815f-946b4768b786',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'task',
    label: 'Task',
    defaultValue: null,
    description: 'Event task',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'taskId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '3536b3af-76a2-44f5-9d89-1961a0a0a763',
    relationTargetObjectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    universalIdentifier: '20202020-b2f5-415c-9135-a31dfe49501b',
  }),
  workflow: getFlatFieldMetadataMock({
    id: '9973da2e-cc65-41b2-8f52-4130cfa31fc6',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'workflow',
    label: 'Workflow',
    defaultValue: null,
    description: 'Event workflow',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'workflowId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '384db7b5-3551-4774-9258-7082b26b502a',
    relationTargetObjectMetadataId: '664c19a5-0693-45d4-a4e5-76c3717db83c',
    universalIdentifier: '20202020-616c-4ad3-a2e9-c477c341e295',
  }),
  workflowVersion: getFlatFieldMetadataMock({
    id: '7e5b7033-8c4f-4bdc-9156-6954c268fbb8',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'workflowVersion',
    label: 'WorkflowVersion',
    defaultValue: null,
    description: 'Event workflow version',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'workflowVersionId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '767ab66d-f3d7-4bac-b0be-f738f8c6fda7',
    relationTargetObjectMetadataId: '99cf5f27-b41d-4f25-a23b-9e47d27dae9b',
    universalIdentifier: '20202020-74f1-4711-a129-e14ca0ecd744',
  }),
  workflowRun: getFlatFieldMetadataMock({
    id: '1cd2b19c-f5c5-40b4-ad41-cc7aa3e955b2',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'workflowRun',
    label: 'Workflow Run',
    defaultValue: null,
    description: 'Event workflow run',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'workflowRunId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'c17fe20f-fcd1-4b21-ac5c-c595473a3af8',
    relationTargetObjectMetadataId: '06d95e96-b050-443f-946e-dd276d291a2f',
    universalIdentifier: '20202020-96f0-401b-9186-a3a0759225ac',
  }),
  rocket: getFlatFieldMetadataMock({
    id: 'eebb9590-817b-4a51-88f7-9792aa8e0a59',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'rocket',
    label: 'Rocket',
    defaultValue: null,
    description: 'TimelineActivities Rocket',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'rocketId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '53a223cc-a445-420d-8698-1a9137039448',
    relationTargetObjectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    universalIdentifier: '20202020-0be6-444e-88f0-12e0c64ac27d',
  }),
  pet: getFlatFieldMetadataMock({
    id: '3cb86390-4ee7-42fa-bd1e-bd6326b47610',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'pet',
    label: 'Pet',
    defaultValue: null,
    description: 'TimelineActivities Pet',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'petId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '4eb74f21-1cb4-46b5-b3bb-4e41108e70d9',
    relationTargetObjectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    universalIdentifier: '20202020-d88f-4020-8c85-d6c600903762',
  }),
  surveyResult: getFlatFieldMetadataMock({
    id: '06010d88-dc3c-4172-92c9-8c73924f950d',
    objectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    type: FieldMetadataType.RELATION,
    name: 'surveyResult',
    label: 'Survey result',
    defaultValue: null,
    description: 'TimelineActivities Survey result',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'surveyResultId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'd544ccb4-b0df-43bb-b70c-57ae477838c4',
    relationTargetObjectMetadataId: '713da753-0340-49b5-b1fa-add34d2dc9a8',
    universalIdentifier: '20202020-d13a-4342-8df0-df48bd783787',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
