import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const TASKTARGET_FLAT_FIELDS_MOCK = {
  id: getFlatFieldMetadataMock({
    id: '762d956d-d11a-4fe6-b6c1-182b9f63a56b',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '040784f1-4b59-4033-b4c7-7ed426d70b65',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: '2b0881e8-767b-4428-ae25-b6ac1a97293a',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: '42b66721-a65c-41bf-a1d7-971ff732be12',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  task: getFlatFieldMetadataMock({
    id: 'c906885c-315a-4783-942e-6caafecf2031',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.RELATION,
    name: 'task',
    label: 'Task',
    defaultValue: null,
    description: 'TaskTarget task',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'taskId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'cd08bc00-d02c-48d4-a1ac-a0cfa13742b7',
    relationTargetObjectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    universalIdentifier: '20202020-e881-457a-8758-74aaef4ae78a',
  }),
  person: getFlatFieldMetadataMock({
    id: '64225f87-96c4-4846-9462-e7aa3ad9e182',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.RELATION,
    name: 'person',
    label: 'Person',
    defaultValue: null,
    description: 'TaskTarget person',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'personId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '9609ca31-215e-47fd-9b3b-ab200acb2fa8',
    relationTargetObjectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    universalIdentifier: '20202020-c8a0-4e85-a016-87e2349cfbec',
  }),
  company: getFlatFieldMetadataMock({
    id: 'ec11b025-1476-4e84-81c5-cf5b5c776edc',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.RELATION,
    name: 'company',
    label: 'Company',
    defaultValue: null,
    description: 'TaskTarget company',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'companyId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '4f9138da-cd36-4df4-98f9-ebabe036b141',
    relationTargetObjectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    universalIdentifier: '20202020-4703-4a4e-948c-487b0c60a92c',
  }),
  opportunity: getFlatFieldMetadataMock({
    id: '49afc8d8-dde3-4d19-aa6b-bd16a751b114',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.RELATION,
    name: 'opportunity',
    label: 'Opportunity',
    defaultValue: null,
    description: 'TaskTarget opportunity',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'opportunityId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'c0c9f9ac-0d40-4206-90e5-0d1e14f8a09f',
    relationTargetObjectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    universalIdentifier: '20202020-6cb2-4c01-a9a5-aca3dbc11d41',
  }),
  rocket: getFlatFieldMetadataMock({
    id: 'a7e80fd8-76bc-45ed-b843-a2b87ef4d601',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.RELATION,
    name: 'rocket',
    label: 'Rocket',
    defaultValue: null,
    description: 'TaskTargets Rocket',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'rocketId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '80e3b587-69ec-48bc-a872-20105c3b7df4',
    relationTargetObjectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    universalIdentifier: '20202020-b98f-473d-85fb-8cebc40b9a50',
  }),
  pet: getFlatFieldMetadataMock({
    id: '3955a4b4-1c10-4ce8-a92e-98e727ee7aec',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.RELATION,
    name: 'pet',
    label: 'Pet',
    defaultValue: null,
    description: 'TaskTargets Pet',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'petId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '3cae8259-ece8-4b81-9044-f5abae5ff25c',
    relationTargetObjectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    universalIdentifier: '20202020-07d9-4d04-8b73-a39ab65943f1',
  }),
  surveyResult: getFlatFieldMetadataMock({
    id: 'caa8b6cf-c668-4fb0-abf9-e49645668020',
    objectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    type: FieldMetadataType.RELATION,
    name: 'surveyResult',
    label: 'Survey result',
    defaultValue: null,
    description: 'TaskTargets Survey result',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'surveyResultId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'c4004fb2-3464-4302-b3c3-a32a1879fed7',
    relationTargetObjectMetadataId: '713da753-0340-49b5-b1fa-add34d2dc9a8',
    universalIdentifier: '20202020-c376-450d-8a49-a573f23eafd8',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
