import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const TASK_FLAT_FIELDS_MOCK = {
  position: getFlatFieldMetadataMock({
    id: '53134864-086f-40ab-a455-11417542ebd4',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.POSITION,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Task record position',
    icon: 'IconHierarchy2',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-7d47-4690-8a98-98b9a0c05dd8',
  }),
  title: getFlatFieldMetadataMock({
    id: '88e4eeac-1d47-4e44-a795-bb5ca93c6557',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.TEXT,
    name: 'title',
    label: 'Title',
    defaultValue: "''",
    description: 'Task title',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b386-4cb7-aa5a-08d4a4d92680',
  }),
  bodyV2: getFlatFieldMetadataMock({
    id: '161570ed-7fcd-4172-a5d1-c773cd9afe76',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.RICH_TEXT_V2,
    name: 'bodyV2',
    label: 'Body',
    defaultValue: null,
    description: 'Task body',
    icon: 'IconFilePencil',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-4aa0-4ae8-898d-7df0afd47ab1',
  }),
  dueAt: getFlatFieldMetadataMock({
    id: '1723b01e-e10b-4410-8cc2-3e0b937754e4',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.DATE_TIME,
    name: 'dueAt',
    label: 'Due Date',
    defaultValue: null,
    description: 'Task due date',
    icon: 'IconCalendarEvent',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-fd99-40da-951b-4cb9a352fce3',
  }),
  status: getFlatFieldMetadataMock({
    id: '44924cd6-fa70-4239-8c22-f17107f83574',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.SELECT,
    name: 'status',
    label: 'Status',
    defaultValue: "'TODO'",
    description: 'Task status',
    icon: 'IconCheck',
    standardOverrides: null,
    options: [
      {
        id: '178a8a6f-6411-4731-a417-36e85e5526a3',
        color: 'sky',
        label: 'To do',
        value: 'TODO',
        position: 0,
      },
      {
        id: 'f6543bd8-3c5e-47ff-b61f-0c2821efd7bf',
        color: 'purple',
        label: 'In progress',
        value: 'IN_PROGRESS',
        position: 1,
      },
      {
        id: '50513334-67ca-4126-ba06-95a1be572ea5',
        color: 'green',
        label: 'Done',
        value: 'DONE',
        position: 2,
      },
    ],
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-70bc-48f9-89c5-6aa730b151e0',
  }),
  createdBy: getFlatFieldMetadataMock({
    id: '575c3d51-5cdc-4ff0-aa67-dcc7f1ba2448',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.ACTOR,
    name: 'createdBy',
    label: 'Created by',
    defaultValue: {
      name: "'System'",
      source: "'MANUAL'",
      workspaceMemberId: null,
    },
    description: 'The creator of the record',
    icon: 'IconCreativeCommonsSa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-1a04-48ab-a567-576965ae5387',
  }),
  searchVector: getFlatFieldMetadataMock({
    id: 'bc00547b-b4c5-4d49-a4f1-97159df5cbc1',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.TS_VECTOR,
    name: 'searchVector',
    label: 'Search vector',
    defaultValue: null,
    description: 'Field used for full-text search',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-4746-4e2f-870c-52b02c67c90d',
  }),
  id: getFlatFieldMetadataMock({
    id: 'dc9b18f9-237c-40ba-97c1-e92c2d7c8e2e',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '10c9e428-0739-48a6-8c39-28e6935dfb7c',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: 'cafcc785-7940-4d27-92e3-ba4b5be5af03',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: 'aa440383-fb91-492c-948f-5b57275cf8e1',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  taskTargets: getFlatFieldMetadataMock({
    id: 'cd08bc00-d02c-48d4-a1ac-a0cfa13742b7',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.RELATION,
    name: 'taskTargets',
    label: 'Relations',
    defaultValue: null,
    description: 'Task targets',
    icon: 'IconArrowUpRight',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'c906885c-315a-4783-942e-6caafecf2031',
    relationTargetObjectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    universalIdentifier: '20202020-de9c-4d0e-a452-713d4a3e5fc7',
  }),
  attachments: getFlatFieldMetadataMock({
    id: '00fd339a-6431-465d-9524-09b5c804f497',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.RELATION,
    name: 'attachments',
    label: 'Attachments',
    defaultValue: null,
    description: 'Task attachments',
    icon: 'IconFileImport',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'bd823f17-f923-4f0d-8533-51d7bc062975',
    relationTargetObjectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    universalIdentifier: '20202020-794d-4783-a8ff-cecdb15be139',
  }),
  assignee: getFlatFieldMetadataMock({
    id: '0e18f5e1-32c3-4daa-b282-ab64fb629b20',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.RELATION,
    name: 'assignee',
    label: 'Assignee',
    defaultValue: null,
    description: 'Task assignee',
    icon: 'IconUserCircle',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'assigneeId',
    },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '68779392-f0ec-42b4-9d89-9645ae84039d',
    relationTargetObjectMetadataId: '7d8264db-2b55-4b74-81ff-b7064ed43840',
    universalIdentifier: '20202020-065a-4f42-a906-e20422c1753f',
  }),
  timelineActivities: getFlatFieldMetadataMock({
    id: '3536b3af-76a2-44f5-9d89-1961a0a0a763',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.RELATION,
    name: 'timelineActivities',
    label: 'Timeline Activities',
    defaultValue: null,
    description: 'Timeline Activities linked to the task.',
    icon: 'IconTimelineEvent',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '187eaeb8-62c8-4925-815f-946b4768b786',
    relationTargetObjectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    universalIdentifier: '20202020-c778-4278-99ee-23a2837aee64',
  }),
  favorites: getFlatFieldMetadataMock({
    id: '33e4eff0-ff0f-4530-802a-cd630481ee84',
    objectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    type: FieldMetadataType.RELATION,
    name: 'favorites',
    label: 'Favorites',
    defaultValue: null,
    description: 'Favorites linked to the task',
    icon: 'IconHeart',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'db16ab78-ea3f-4b67-93e3-6ad9ab1b7273',
    relationTargetObjectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    universalIdentifier: '20202020-4d1d-41ac-b13b-621631298d65',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
