import { FieldMetadataType } from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const ROCKET_FLAT_FIELDS_MOCK = {
  id: getFlatFieldMetadataMock({
    id: 'c7c23914-80c4-46d2-a559-1ce20d07fb3c',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  name: getFlatFieldMetadataMock({
    id: '9c10de36-1ade-4be1-af78-c4fc55669fbd',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.TEXT,
    name: 'name',
    label: 'Name',
    defaultValue: "'Untitled'",
    description: 'Name',
    icon: 'IconAbc',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-ba07-4ffd-ba63-009491f5749c',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '7aa0896a-82dd-43c0-b38f-a316a8064d51',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: '1ca95b19-f02d-43c1-b9ae-8a9d522bb34b',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: 'aae8d11a-27b3-4844-a68f-a2023ae12443',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Deletion date',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  createdBy: getFlatFieldMetadataMock({
    id: '23ebf744-88ad-4d0f-9084-a63e29c4655b',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.ACTOR,
    name: 'createdBy',
    label: 'Created by',
    defaultValue: { name: "''", source: "'MANUAL'" },
    description: 'The creator of the record',
    icon: 'IconCreativeCommonsSa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-be0e-4971-865b-32ca87cbb315',
  }),
  position: getFlatFieldMetadataMock({
    id: '2f1976a6-ae59-43c5-85bc-49fb8fd03e18',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.POSITION,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Position',
    icon: 'IconHierarchy2',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-c2bd-4e16-bb9a-c8b0411bf49d',
  }),
  timelineActivities: getFlatFieldMetadataMock({
    id: '53a223cc-a445-420d-8698-1a9137039448',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.RELATION,
    name: 'timelineActivities',
    label: 'TimelineActivities',
    defaultValue: null,
    description: 'TimelineActivities tied to the Rocket',
    icon: 'IconTimelineEvent',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'eebb9590-817b-4a51-88f7-9792aa8e0a59',
    relationTargetObjectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    universalIdentifier: '20202020-f1ef-4ba4-8f33-1a4577afa477',
  }),
  favorites: getFlatFieldMetadataMock({
    id: '14010360-f3c2-442e-b05f-43c30158f246',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.RELATION,
    name: 'favorites',
    label: 'Favorites',
    defaultValue: null,
    description: 'Favorites tied to the Rocket',
    icon: 'IconHeart',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '9448627d-725d-499e-a071-90fd5cfcf0ea',
    relationTargetObjectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    universalIdentifier: '20202020-a4a7-4686-b296-1c6c3482ee21',
  }),
  attachments: getFlatFieldMetadataMock({
    id: 'f5984acf-5128-42ac-840f-9d2888423699',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.RELATION,
    name: 'attachments',
    label: 'Attachments',
    defaultValue: null,
    description: 'Attachments tied to the Rocket',
    icon: 'IconFileImport',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'ba23019c-7f25-42c3-8138-622e61c42968',
    relationTargetObjectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    universalIdentifier: '20202020-8d59-46ca-b7b2-73d167712134',
  }),
  noteTargets: getFlatFieldMetadataMock({
    id: 'c91376fb-20bd-47c7-8922-b64f7db51cfa',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.RELATION,
    name: 'noteTargets',
    label: 'NoteTargets',
    defaultValue: null,
    description: 'NoteTargets tied to the Rocket',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '4212b3d7-dd9f-4da9-85f7-2fa69a42296f',
    relationTargetObjectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    universalIdentifier: '20202020-01fd-4f37-99dc-9427a444018a',
  }),
  taskTargets: getFlatFieldMetadataMock({
    id: '80e3b587-69ec-48bc-a872-20105c3b7df4',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.RELATION,
    name: 'taskTargets',
    label: 'TaskTargets',
    defaultValue: null,
    description: 'TaskTargets tied to the Rocket',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'a7e80fd8-76bc-45ed-b843-a2b87ef4d601',
    relationTargetObjectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    universalIdentifier: '20202020-0860-4566-b865-bff3c626c303',
  }),
  searchVector: getFlatFieldMetadataMock({
    id: 'e7609ea3-5a88-4d64-b0c1-eefd4602361a',
    objectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    type: FieldMetadataType.TS_VECTOR,
    name: 'searchVector',
    label: 'Search vector',
    defaultValue: null,
    description: 'Field used for full-text search',
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: false,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '70e56537-18ef-4811-b1c7-0a444006b815',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
