import { FieldMetadataType } from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const PET_FLAT_FIELDS_MOCK = {
  noteTargets: getFlatFieldMetadataMock({
    id: '98afd46e-0259-4c87-969d-16e7e660e007',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RELATION,
    name: 'noteTargets',
    label: 'NoteTargets',
    defaultValue: null,
    description: 'NoteTargets tied to the Pet',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'd88d0737-e83a-47b1-b701-8edfe4a2ae2e',
    relationTargetObjectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    universalIdentifier: '20202020-01fd-4f37-99dc-9427a444018a',
  }),
  id: getFlatFieldMetadataMock({
    id: 'ce25501a-1cc6-44c5-9158-b602db0efaca',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  name: getFlatFieldMetadataMock({
    id: '4311d4e0-ce63-479c-a4da-5b244e2348cc',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.TEXT,
    name: 'name',
    label: 'Name',
    defaultValue: "'Untitled'",
    description: 'Name',
    icon: 'IconAbc',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-ba07-4ffd-ba63-009491f5749c',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '0bbe259b-0fd1-43ca-922f-1c0b7960efbe',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: 'c96d123d-4c13-47ee-85bf-00428ce5e242',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: 'bbfd9b09-be13-4232-af2c-585a9137aa62',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Deletion date',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  createdBy: getFlatFieldMetadataMock({
    id: '2090b892-376c-4349-990d-6a789b53e31d',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.ACTOR,
    name: 'createdBy',
    label: 'Created by',
    defaultValue: { name: "''", source: "'MANUAL'" },
    description: 'The creator of the record',
    icon: 'IconCreativeCommonsSa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-be0e-4971-865b-32ca87cbb315',
  }),
  position: getFlatFieldMetadataMock({
    id: '3087f7da-f422-4b69-9b95-fadef79dd12a',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.POSITION,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Position',
    icon: 'IconHierarchy2',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-c2bd-4e16-bb9a-c8b0411bf49d',
  }),
  timelineActivities: getFlatFieldMetadataMock({
    id: '4eb74f21-1cb4-46b5-b3bb-4e41108e70d9',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RELATION,
    name: 'timelineActivities',
    label: 'TimelineActivities',
    defaultValue: null,
    description: 'TimelineActivities tied to the Pet',
    icon: 'IconTimelineEvent',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '3cb86390-4ee7-42fa-bd1e-bd6326b47610',
    relationTargetObjectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    universalIdentifier: '20202020-f1ef-4ba4-8f33-1a4577afa477',
  }),
  favorites: getFlatFieldMetadataMock({
    id: '80bc4e7a-6bd1-4f2b-98b1-6333c631cc1a',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RELATION,
    name: 'favorites',
    label: 'Favorites',
    defaultValue: null,
    description: 'Favorites tied to the Pet',
    icon: 'IconHeart',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'd34b4048-bf0c-4c61-8ffe-59f1838a2cc4',
    relationTargetObjectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    universalIdentifier: '20202020-a4a7-4686-b296-1c6c3482ee21',
  }),
  attachments: getFlatFieldMetadataMock({
    id: '231903d0-3b14-47ed-9a88-fbf11031c451',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RELATION,
    name: 'attachments',
    label: 'Attachments',
    defaultValue: null,
    description: 'Attachments tied to the Pet',
    icon: 'IconFileImport',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '317a33ef-117e-4953-86d4-c4a9670a2ce3',
    relationTargetObjectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    universalIdentifier: '20202020-8d59-46ca-b7b2-73d167712134',
  }),
  taskTargets: getFlatFieldMetadataMock({
    id: '3cae8259-ece8-4b81-9044-f5abae5ff25c',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RELATION,
    name: 'taskTargets',
    label: 'TaskTargets',
    defaultValue: null,
    description: 'TaskTargets tied to the Pet',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '3955a4b4-1c10-4ce8-a92e-98e727ee7aec',
    relationTargetObjectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    universalIdentifier: '20202020-0860-4566-b865-bff3c626c303',
  }),
  searchVector: getFlatFieldMetadataMock({
    id: '0db37175-e573-43e4-bd83-fa71923fde0c',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.TS_VECTOR,
    name: 'searchVector',
    label: 'Search vector',
    defaultValue: null,
    description: 'Field used for full-text search',
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: false,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '70e56537-18ef-4811-b1c7-0a444006b815',
  }),
  species: getFlatFieldMetadataMock({
    id: '0292cc51-246f-40b8-99e8-3345dac0e688',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.SELECT,
    name: 'species',
    label: 'Species',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: [
      {
        id: '23a75463-ca50-4b33-bfd8-701e2944c76c',
        color: 'blue',
        label: 'Dog',
        value: 'DOG',
        position: 0,
      },
      {
        id: 'e4669573-b219-44e1-a857-ed9fb31c51cd',
        color: 'red',
        label: 'Cat',
        value: 'CAT',
        position: 1,
      },
      {
        id: '26cc93c8-e2ef-452a-80c3-60d274033f38',
        color: 'green',
        label: 'Bird',
        value: 'BIRD',
        position: 2,
      },
      {
        id: '364e1363-166d-4dbd-b39b-c50e658b536c',
        color: 'yellow',
        label: 'Fish',
        value: 'FISH',
        position: 3,
      },
      {
        id: '041726a2-73b8-45de-b311-6deeec79886e',
        color: 'purple',
        label: 'Rabbit',
        value: 'RABBIT',
        position: 4,
      },
      {
        id: '3966dd54-985e-49d9-ab13-aea1346763d4',
        color: 'orange',
        label: 'Hamster',
        value: 'HAMSTER',
        position: 5,
      },
    ],
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '0292cc51-246f-40b8-99e8-3345dac0e688',
  }),
  traits: getFlatFieldMetadataMock({
    id: '5aaf6be0-b9f5-4222-9810-941d5ab58527',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.MULTI_SELECT,
    name: 'traits',
    label: 'Traits',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: [
      {
        id: '5bb37088-b364-44c5-a984-54b01aa241ce',
        color: 'blue',
        label: 'Playful',
        value: 'PLAYFUL',
        position: 0,
      },
      {
        id: '69d7d78d-3983-4e3b-aec5-6e6daafb06d6',
        color: 'red',
        label: 'Friendly',
        value: 'FRIENDLY',
        position: 1,
      },
      {
        id: 'c5d7fa50-ed21-4373-bcca-ae7006e3a784',
        color: 'green',
        label: 'Protective',
        value: 'PROTECTIVE',
        position: 2,
      },
      {
        id: '85595ae8-5d17-4580-8c99-cd429f509d75',
        color: 'yellow',
        label: 'Shy',
        value: 'SHY',
        position: 3,
      },
      {
        id: '77d4bffb-8da3-4aad-ab08-fa5f0b0ab0f2',
        color: 'purple',
        label: 'Brave',
        value: 'BRAVE',
        position: 4,
      },
      {
        id: '4942a08c-00fd-43a1-99bb-79288d9c4e6a',
        color: 'orange',
        label: 'Curious',
        value: 'CURIOUS',
        position: 5,
      },
    ],
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '5aaf6be0-b9f5-4222-9810-941d5ab58527',
  }),
  comments: getFlatFieldMetadataMock({
    id: '2e726631-d80a-4594-9a5a-3cca0c2a50a9',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.TEXT,
    name: 'comments',
    label: 'Comments',
    defaultValue: "''",
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '2e726631-d80a-4594-9a5a-3cca0c2a50a9',
  }),
  age: getFlatFieldMetadataMock({
    id: 'ed1573cf-b29e-4d4f-a8e3-19d472d28c0d',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.NUMBER,
    name: 'age',
    label: 'Age',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: 'ed1573cf-b29e-4d4f-a8e3-19d472d28c0d',
  }),
  location: getFlatFieldMetadataMock({
    id: '7b05e127-d0ea-422a-8f98-ef48f41d4388',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.ADDRESS,
    name: 'location',
    label: 'Location',
    defaultValue: {
      addressLat: null,
      addressLng: null,
      addressCity: "''",
      addressState: "''",
      addressCountry: "''",
      addressStreet1: "''",
      addressStreet2: "''",
      addressPostcode: "''",
    },
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '7b05e127-d0ea-422a-8f98-ef48f41d4388',
  }),
  vetPhone: getFlatFieldMetadataMock({
    id: '92c856ef-5b4b-4202-8c23-b2f22f959eda',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.PHONES,
    name: 'vetPhone',
    label: 'Vet phone',
    defaultValue: {
      additionalPhones: null,
      primaryPhoneNumber: "''",
      primaryPhoneCallingCode: "''",
      primaryPhoneCountryCode: "''",
    },
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '92c856ef-5b4b-4202-8c23-b2f22f959eda',
  }),
  vetEmail: getFlatFieldMetadataMock({
    id: '2c89697d-925a-485c-a0ed-adf2f1228e0f',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.EMAILS,
    name: 'vetEmail',
    label: 'Vet email',
    defaultValue: { primaryEmail: "''", additionalEmails: null },
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '2c89697d-925a-485c-a0ed-adf2f1228e0f',
  }),
  birthday: getFlatFieldMetadataMock({
    id: '13c5b4ed-5746-494f-856b-081bdbb4a8ec',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.DATE,
    name: 'birthday',
    label: 'Birthday',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '13c5b4ed-5746-494f-856b-081bdbb4a8ec',
  }),
  isGoodWithKids: getFlatFieldMetadataMock({
    id: 'ec3bf27e-70e6-4d4a-932e-6ef026013603',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.BOOLEAN,
    name: 'isGoodWithKids',
    label: 'Is good with kids',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: 'ec3bf27e-70e6-4d4a-932e-6ef026013603',
  }),
  pictures: getFlatFieldMetadataMock({
    id: '8aa0a700-c308-4d8b-8fbd-f545daa8980a',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.LINKS,
    name: 'pictures',
    label: 'Pictures',
    defaultValue: {
      primaryLinkUrl: "''",
      secondaryLinks: [],
      primaryLinkLabel: "''",
    },
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '8aa0a700-c308-4d8b-8fbd-f545daa8980a',
  }),
  averageCostOfKibblePerMonth: getFlatFieldMetadataMock({
    id: '37421848-b64d-4827-be33-da4e337acbb6',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.CURRENCY,
    name: 'averageCostOfKibblePerMonth',
    label: 'Average cost of kibble per month',
    defaultValue: { amountMicros: null, currencyCode: "''" },
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '37421848-b64d-4827-be33-da4e337acbb6',
  }),
  makesOwnerThinkOf: getFlatFieldMetadataMock({
    id: '84b874dc-983d-47eb-9c67-54f557a99f60',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.FULL_NAME,
    name: 'makesOwnerThinkOf',
    label: 'Makes its owner think of',
    defaultValue: { lastName: "''", firstName: "''" },
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '84b874dc-983d-47eb-9c67-54f557a99f60',
  }),
  soundSwag: getFlatFieldMetadataMock({
    id: '42e6c0d2-6d00-4c77-b179-890af8c56236',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RATING,
    name: 'soundSwag',
    label: 'Sound swag (bark style, meow style, etc.)',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: [
      {
        id: '4a3ed94d-30db-4231-8c2e-5893d55df860',
        label: '1',
        value: 'RATING_1',
        position: 0,
      },
      {
        id: '7b837621-34e5-4a65-be45-9386062150c6',
        label: '2',
        value: 'RATING_2',
        position: 1,
      },
      {
        id: '1b0aa9fd-c4b9-4714-952f-492da858f766',
        label: '3',
        value: 'RATING_3',
        position: 2,
      },
      {
        id: '35b92ebf-ecc7-4a9d-9ef2-4739cbfcb61a',
        label: '4',
        value: 'RATING_4',
        position: 3,
      },
      {
        id: 'a225c6ca-301b-4f90-bb3e-17edbcb84d92',
        label: '5',
        value: 'RATING_5',
        position: 4,
      },
    ],
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '42e6c0d2-6d00-4c77-b179-890af8c56236',
  }),
  bio: getFlatFieldMetadataMock({
    id: 'fa0ec409-0f29-4b19-b304-31d1018a2344',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RICH_TEXT,
    name: 'bio',
    label: 'Bio',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: 'fa0ec409-0f29-4b19-b304-31d1018a2344',
  }),
  interestingFacts: getFlatFieldMetadataMock({
    id: '2b806a74-e7a5-4ec7-b902-67cf811e8bda',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.ARRAY,
    name: 'interestingFacts',
    label: 'Interesting facts',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '2b806a74-e7a5-4ec7-b902-67cf811e8bda',
  }),
  extraData: getFlatFieldMetadataMock({
    id: 'a79bd7c8-c7ce-416a-9d12-a05335c9c596',
    objectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    type: FieldMetadataType.RAW_JSON,
    name: 'extraData',
    label: 'Extra data',
    defaultValue: null,
    description: null,
    icon: null,
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: 'a79bd7c8-c7ce-416a-9d12-a05335c9c596',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
