import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const PERSON_FLAT_FIELDS_MOCK = {
  name: getFlatFieldMetadataMock({
    id: 'f410c1cd-2523-4802-be8e-1acc852b4b1a',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.FULL_NAME,
    name: 'name',
    label: 'Name',
    defaultValue: { lastName: "''", firstName: "''" },
    description: 'Contact’s name',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-3875-44d5-8c33-a6239011cab8',
  }),
  emails: getFlatFieldMetadataMock({
    id: '012dd567-b7d9-4088-a0c1-4ded96a25e35',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.EMAILS,
    name: 'emails',
    label: 'Emails',
    defaultValue: { primaryEmail: "''", additionalEmails: null },
    description: 'Contact’s Emails',
    icon: 'IconMail',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: true,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-3c51-43fa-8b6e-af39e29368ab',
  }),
  linkedinLink: getFlatFieldMetadataMock({
    id: '86e35da6-151d-47e3-8745-bb1e652b789c',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.LINKS,
    name: 'linkedinLink',
    label: 'Linkedin',
    defaultValue: {
      primaryLinkUrl: "''",
      secondaryLinks: [],
      primaryLinkLabel: "''",
    },
    description: 'Contact’s Linkedin account',
    icon: 'IconBrandLinkedin',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-f1af-48f7-893b-2007a73dd508',
  }),
  xLink: getFlatFieldMetadataMock({
    id: 'c9d36790-a449-4108-91e1-c6ad6e3379fb',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.LINKS,
    name: 'xLink',
    label: 'X',
    defaultValue: {
      primaryLinkUrl: "''",
      secondaryLinks: [],
      primaryLinkLabel: "''",
    },
    description: 'Contact’s X/Twitter account',
    icon: 'IconBrandX',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-8fc2-487c-b84a-55a99b145cfd',
  }),
  jobTitle: getFlatFieldMetadataMock({
    id: 'ab82c659-b553-4317-9708-998f6884c72e',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.TEXT,
    name: 'jobTitle',
    label: 'Job Title',
    defaultValue: "''",
    description: 'Contact’s job title',
    icon: 'IconBriefcase',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b0d0-415a-bef9-640a26dacd9b',
  }),
  phones: getFlatFieldMetadataMock({
    id: '4955e9cb-a740-49fa-9c91-69ec74a6b3df',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.PHONES,
    name: 'phones',
    label: 'Phones',
    defaultValue: {
      additionalPhones: null,
      primaryPhoneNumber: "''",
      primaryPhoneCallingCode: "''",
      primaryPhoneCountryCode: "''",
    },
    description: 'Contact’s phone numbers',
    icon: 'IconPhone',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-0638-448e-8825-439134618022',
  }),
  city: getFlatFieldMetadataMock({
    id: '61ad7592-6465-4a24-a863-0320cf7830a6',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.TEXT,
    name: 'city',
    label: 'City',
    defaultValue: "''",
    description: 'Contact’s city',
    icon: 'IconMap',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-5243-4ffb-afc5-2c675da41346',
  }),
  avatarUrl: getFlatFieldMetadataMock({
    id: '05e46775-93e9-46c4-8b6f-94829045b1ad',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.TEXT,
    name: 'avatarUrl',
    label: 'Avatar',
    defaultValue: "''",
    description: 'Contact’s avatar',
    icon: 'IconFileUpload',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b8a6-40df-961c-373dc5d2ec21',
  }),
  position: getFlatFieldMetadataMock({
    id: '5162d850-29dd-474e-982b-24257b57fd46',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.POSITION,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Person record Position',
    icon: 'IconHierarchy2',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-fcd5-4231-aff5-fff583eaa0b1',
  }),
  createdBy: getFlatFieldMetadataMock({
    id: '1a3de345-4f47-4dc9-b328-61c802efa36e',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.ACTOR,
    name: 'createdBy',
    label: 'Created by',
    defaultValue: {
      name: "'System'",
      source: "'MANUAL'",
      workspaceMemberId: null,
    },
    description: 'The creator of the record',
    icon: 'IconCreativeCommonsSa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-f6ab-4d98-af24-a3d5b664148a',
  }),
  searchVector: getFlatFieldMetadataMock({
    id: '1d7f79d4-7811-45dc-8f9f-5dbd4863d0a1',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.TS_VECTOR,
    name: 'searchVector',
    label: 'Search vector',
    defaultValue: null,
    description: 'Field used for full-text search',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '57d1d7ad-fa10-44fc-82f3-ad0959ec2534',
  }),
  id: getFlatFieldMetadataMock({
    id: 'd9b3e129-49ce-4843-a813-9d16f2239472',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '9fec2460-6fd2-4aaf-8781-78893ba61d6d',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: '6a00c4b7-d77c-4268-85e7-9e3a597bd0e7',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: 'a9f5469d-d7ff-42f6-b3a7-399c8ab8b468',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  company: getFlatFieldMetadataMock({
    id: 'ee247ca6-fdaa-4a56-87a2-730cf84f5f29',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'company',
    label: 'Company',
    defaultValue: null,
    description: 'Contact’s company',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'companyId',
    },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'b0563539-f027-40c5-a14c-ee7a25ff6fd9',
    relationTargetObjectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    universalIdentifier: '20202020-e2f3-448e-b34c-2d625f0025fd',
  }),
  pointOfContactForOpportunities: getFlatFieldMetadataMock({
    id: '7580c1b1-e8f9-480b-bd41-38b20df35777',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'pointOfContactForOpportunities',
    label: 'Opportunities',
    defaultValue: null,
    description:
      'List of opportunities for which that person is the point of contact',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '0e55bf63-1ffb-4f74-89f2-edd5a6a6686c',
    relationTargetObjectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    universalIdentifier: '20202020-911b-4a7d-b67b-918aa9a5b33a',
  }),
  taskTargets: getFlatFieldMetadataMock({
    id: '9609ca31-215e-47fd-9b3b-ab200acb2fa8',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'taskTargets',
    label: 'Tasks',
    defaultValue: null,
    description: 'Tasks tied to the contact',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '64225f87-96c4-4846-9462-e7aa3ad9e182',
    relationTargetObjectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    universalIdentifier: '20202020-584b-4d3e-88b6-53ab1fa03c3a',
  }),
  noteTargets: getFlatFieldMetadataMock({
    id: '60388ed8-45f6-4fb5-8752-81c73e13f4ab',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'noteTargets',
    label: 'Notes',
    defaultValue: null,
    description: 'Notes tied to the contact',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '560c71ff-254f-4baf-a4d1-054c53444f41',
    relationTargetObjectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    universalIdentifier: '20202020-c8fc-4258-8250-15905d3fcfec',
  }),
  favorites: getFlatFieldMetadataMock({
    id: 'a1a72bee-1c15-4598-ba23-67ba8e3e505d',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'favorites',
    label: 'Favorites',
    defaultValue: null,
    description: 'Favorites linked to the contact',
    icon: 'IconHeart',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '013cec20-e9cc-42db-b9b9-ff6bd0f52abd',
    relationTargetObjectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    universalIdentifier: '20202020-4073-4117-9cf1-203bcdc91cbd',
  }),
  attachments: getFlatFieldMetadataMock({
    id: '367ad117-de09-466c-94f8-ce99d951b5ce',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'attachments',
    label: 'Attachments',
    defaultValue: null,
    description: 'Attachments linked to the contact.',
    icon: 'IconFileImport',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '6938c2ec-ebcc-4f30-8d38-2c9c40228c53',
    relationTargetObjectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    universalIdentifier: '20202020-cd97-451f-87fa-bcb789bdbf3a',
  }),
  messageParticipants: getFlatFieldMetadataMock({
    id: '22dcab3c-939c-4b8d-bd7c-4c4d58588460',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'messageParticipants',
    label: 'Message Participants',
    defaultValue: null,
    description: 'Message Participants',
    icon: 'IconUserCircle',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'e95d7d1a-9101-4048-b019-d2f8bc110328',
    relationTargetObjectMetadataId: 'edb170fd-a0c2-4619-b1a9-293cf07437c4',
    universalIdentifier: '20202020-498e-4c61-8158-fa04f0638334',
  }),
  calendarEventParticipants: getFlatFieldMetadataMock({
    id: '9e82a873-2988-4d9d-af04-81f2d947f4ec',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'calendarEventParticipants',
    label: 'Calendar Event Participants',
    defaultValue: null,
    description: 'Calendar Event Participants',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'e39f443d-3282-47a3-a24d-47ed604d58be',
    relationTargetObjectMetadataId: 'a4c662b6-e08d-40a5-ae55-82ed8f4edf78',
    universalIdentifier: '20202020-52ee-45e9-a702-b64b3753e3a9',
  }),
  timelineActivities: getFlatFieldMetadataMock({
    id: 'b1457347-545b-4a42-9c68-bc655952229a',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RELATION,
    name: 'timelineActivities',
    label: 'Events',
    defaultValue: null,
    description: 'Events linked to the person',
    icon: 'IconTimelineEvent',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'dbd02754-4bef-4149-b39d-54759983ab47',
    relationTargetObjectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    universalIdentifier: '20202020-a43e-4873-9c23-e522de906ce5',
  }),
  intro: getFlatFieldMetadataMock({
    id: '94c95bfa-88bc-4271-87c2-08e6df084a15',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.TEXT,
    name: 'intro',
    label: 'Intro',
    defaultValue: "''",
    description: null,
    icon: 'IconNote',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '94c95bfa-88bc-4271-87c2-08e6df084a15',
  }),
  whatsapp: getFlatFieldMetadataMock({
    id: 'adc26aa8-d146-49d2-a037-77e15d8b20fc',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.PHONES,
    name: 'whatsapp',
    label: 'Whatsapp',
    defaultValue: {
      additionalPhones: null,
      primaryPhoneNumber: "''",
      primaryPhoneCallingCode: "'+33'",
      primaryPhoneCountryCode: "'FR'",
    },
    description: null,
    icon: 'IconBrandWhatsapp',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: 'adc26aa8-d146-49d2-a037-77e15d8b20fc',
  }),
  workPreference: getFlatFieldMetadataMock({
    id: '421b5788-94dd-40b0-8d5f-6c649d7464c4',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.MULTI_SELECT,
    name: 'workPreference',
    label: 'Work Preference',
    defaultValue: null,
    description: null,
    icon: 'IconHome',
    standardOverrides: null,
    options: [
      {
        id: 'c33d02fd-0bd9-4769-bd32-036d9ff645a5',
        color: 'green',
        label: 'On-Site',
        value: 'ON_SITE',
        position: 0,
      },
      {
        id: '98d938d8-9439-4483-9944-ec073c9a3986',
        color: 'turquoise',
        label: 'Hybrid',
        value: 'HYBRID',
        position: 1,
      },
      {
        id: '661f6ba8-7340-4830-ab0c-b6d8ed658ade',
        color: 'sky',
        label: 'Remote Work',
        value: 'REMOTE_WORK',
        position: 2,
      },
    ],
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '421b5788-94dd-40b0-8d5f-6c649d7464c4',
  }),
  performanceRating: getFlatFieldMetadataMock({
    id: 'f75b0e71-e34c-4bc9-bb91-55a94127ab82',
    objectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    type: FieldMetadataType.RATING,
    name: 'performanceRating',
    label: 'Performance Rating',
    defaultValue: null,
    description: null,
    icon: 'IconStars',
    standardOverrides: null,
    options: [
      {
        id: 'e6b4b1bb-c707-41cb-8f30-418a81ae3299',
        label: '1',
        value: 'RATING_1',
        position: 0,
      },
      {
        id: '5eaa1985-6970-4add-ab73-9e7a590f7a27',
        label: '2',
        value: 'RATING_2',
        position: 1,
      },
      {
        id: '6b61794f-42d5-4a3a-8cb3-f911aac15803',
        label: '3',
        value: 'RATING_3',
        position: 2,
      },
      {
        id: '3ed5ba36-8c24-400b-b58a-d2ee306bb46f',
        label: '4',
        value: 'RATING_4',
        position: 3,
      },
      {
        id: 'af3beb45-5937-4c4b-8aa4-3cc3f356d131',
        label: '5',
        value: 'RATING_5',
        position: 4,
      },
    ],
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: 'f75b0e71-e34c-4bc9-bb91-55a94127ab82',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
