import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const NOTETARGET_FLAT_FIELDS_MOCK = {
  id: getFlatFieldMetadataMock({
    id: '3ef6c3df-6569-4d00-b1ae-3893e8e55a7e',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '3cecf38d-1186-4e66-9eb6-06516d3b3172',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: '41e0ee99-7319-4709-a11a-b0d624625359',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: '3ef1221e-649f-41f9-a360-12896e3c0935',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  note: getFlatFieldMetadataMock({
    id: 'b1e812b7-604e-459b-9449-31fa414b315c',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.RELATION,
    name: 'note',
    label: 'Note',
    defaultValue: null,
    description: 'NoteTarget note',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'noteId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '3a13d398-b7e6-4871-a5f8-5446806b3e5b',
    relationTargetObjectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    universalIdentifier: '20202020-57f3-4f50-9599-fc0f671df003',
  }),
  person: getFlatFieldMetadataMock({
    id: '560c71ff-254f-4baf-a4d1-054c53444f41',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.RELATION,
    name: 'person',
    label: 'Person',
    defaultValue: null,
    description: 'NoteTarget person',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'personId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '60388ed8-45f6-4fb5-8752-81c73e13f4ab',
    relationTargetObjectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    universalIdentifier: '20202020-38ca-4aab-92f5-8a605ca2e4c5',
  }),
  company: getFlatFieldMetadataMock({
    id: 'd1d3f9eb-1447-4adb-bc2b-f133bc58ac35',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.RELATION,
    name: 'company',
    label: 'Company',
    defaultValue: null,
    description: 'NoteTarget company',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'companyId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '56b9dc8a-0379-42cf-ab31-8db7061f5a2a',
    relationTargetObjectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    universalIdentifier: 'c500fbc0-d6f2-4982-a959-5a755431696c',
  }),
  opportunity: getFlatFieldMetadataMock({
    id: 'f42eac2a-8d99-4259-b69a-549abd553eda',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.RELATION,
    name: 'opportunity',
    label: 'Opportunity',
    defaultValue: null,
    description: 'NoteTarget opportunity',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'opportunityId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '36210a54-a72e-4530-a1eb-a0420c53e551',
    relationTargetObjectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    universalIdentifier: '20202020-4e42-417a-a705-76581c9ade79',
  }),
  rocket: getFlatFieldMetadataMock({
    id: '4212b3d7-dd9f-4da9-85f7-2fa69a42296f',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.RELATION,
    name: 'rocket',
    label: 'Rocket',
    defaultValue: null,
    description: 'NoteTargets Rocket',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'rocketId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'c91376fb-20bd-47c7-8922-b64f7db51cfa',
    relationTargetObjectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    universalIdentifier: '20202020-52b6-4d5e-8f21-ed8b7c09c4a9',
  }),
  pet: getFlatFieldMetadataMock({
    id: 'd88d0737-e83a-47b1-b701-8edfe4a2ae2e',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.RELATION,
    name: 'pet',
    label: 'Pet',
    defaultValue: null,
    description: 'NoteTargets Pet',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'petId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '98afd46e-0259-4c87-969d-16e7e660e007',
    relationTargetObjectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    universalIdentifier: '20202020-c54e-4804-8b0d-8795e5166432',
  }),
  surveyResult: getFlatFieldMetadataMock({
    id: '7f444190-cb0e-4417-9c61-e59d8969b7f7',
    objectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    type: FieldMetadataType.RELATION,
    name: 'surveyResult',
    label: 'Survey result',
    defaultValue: null,
    description: 'NoteTargets Survey result',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'surveyResultId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '1135971a-b1fa-4e63-b480-69410c6a09cd',
    relationTargetObjectMetadataId: '713da753-0340-49b5-b1fa-add34d2dc9a8',
    universalIdentifier: '20202020-75c4-4165-8146-dfdc2a76b940',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
