import { FieldMetadataType, DateDisplayFormat } from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const NOTE_FLAT_FIELDS_MOCK = {
  position: getFlatFieldMetadataMock({
    id: '3ea4b48b-3b88-4db5-b455-c7c77b208599',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.POSITION,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Note record position',
    icon: 'IconHierarchy2',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-368d-4dc2-943f-ed8a49c7fdfb',
  }),
  title: getFlatFieldMetadataMock({
    id: '3cb30a3f-31c1-47d3-a61e-e537615390c8',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.TEXT,
    name: 'title',
    label: 'Title',
    defaultValue: "''",
    description: 'Note title',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-faeb-4c76-8ba6-ccbb0b4a965f',
  }),
  bodyV2: getFlatFieldMetadataMock({
    id: 'acb2973c-7e46-4296-ac79-8b8d163b6d85',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.RICH_TEXT_V2,
    name: 'bodyV2',
    label: 'Body',
    defaultValue: null,
    description: 'Note body',
    icon: 'IconFilePencil',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-a7bb-4d94-be51-8f25181502c8',
  }),
  createdBy: getFlatFieldMetadataMock({
    id: '1caa79de-f2ec-405c-8667-7a65e9a3bcbf',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.ACTOR,
    name: 'createdBy',
    label: 'Created by',
    defaultValue: {
      name: "'System'",
      source: "'MANUAL'",
      workspaceMemberId: null,
    },
    description: 'The creator of the record',
    icon: 'IconCreativeCommonsSa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-0d79-4e21-ab77-5a394eff97be',
  }),
  searchVector: getFlatFieldMetadataMock({
    id: '597b0c10-840e-4ba5-99db-7ef834a72bed',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.TS_VECTOR,
    name: 'searchVector',
    label: 'Search vector',
    defaultValue: null,
    description: 'Field used for full-text search',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-7ea8-44d4-9d4c-51dd2a757950',
  }),
  id: getFlatFieldMetadataMock({
    id: '6ece96a9-2948-4735-8c8a-40cdb76e23b8',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '0b849709-eee4-4d63-9fef-058cfdd0c098',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: '8b4fe2dd-f4fa-4365-964d-d8f0dd7890cd',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: 'fbf20b48-0aca-49a2-b3a8-67d0d7dfe104',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  noteTargets: getFlatFieldMetadataMock({
    id: '3a13d398-b7e6-4871-a5f8-5446806b3e5b',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.RELATION,
    name: 'noteTargets',
    label: 'Relations',
    defaultValue: null,
    description: 'Note targets',
    icon: 'IconArrowUpRight',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'b1e812b7-604e-459b-9449-31fa414b315c',
    relationTargetObjectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    universalIdentifier: '20202020-1f25-43fe-8b00-af212fdde823',
  }),
  attachments: getFlatFieldMetadataMock({
    id: '4d4b3225-ddd2-4d76-a4d6-bcdd43a256e8',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.RELATION,
    name: 'attachments',
    label: 'Attachments',
    defaultValue: null,
    description: 'Note attachments',
    icon: 'IconFileImport',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '5a98eb2b-1120-42e3-afd3-09d7da642fba',
    relationTargetObjectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    universalIdentifier: '20202020-4986-4c92-bf19-39934b149b16',
  }),
  timelineActivities: getFlatFieldMetadataMock({
    id: '1207d260-db2c-41d4-bb09-34ea1188978f',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.RELATION,
    name: 'timelineActivities',
    label: 'Timeline Activities',
    defaultValue: null,
    description: 'Timeline Activities linked to the note.',
    icon: 'IconTimelineEvent',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '2b9f1c90-9e35-4ccc-8d84-b42de31ef127',
    relationTargetObjectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    universalIdentifier: '20202020-7030-42f8-929c-1a57b25d6bce',
  }),
  favorites: getFlatFieldMetadataMock({
    id: '065a1ede-f773-48ca-84bf-70f61d838396',
    objectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    type: FieldMetadataType.RELATION,
    name: 'favorites',
    label: 'Favorites',
    defaultValue: null,
    description: 'Favorites linked to the note',
    icon: 'IconHeart',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'a61baf0f-2d43-4fda-9baf-efb000c17ecd',
    relationTargetObjectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    universalIdentifier: '20202020-4d1d-41ac-b13b-621631298d67',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
