import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const COMPANY_FLAT_FIELDS_MOCK = {
  name: getFlatFieldMetadataMock({
    id: '12b304b6-ea97-4dcc-9415-9f7b2ac4b729',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.TEXT,
    name: 'name',
    label: 'Name',
    defaultValue: "''",
    description: 'The company name',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-4d99-4e2e-a84c-4a27837b1ece',
  }),
  domainName: getFlatFieldMetadataMock({
    id: 'f4b67402-1686-491f-a3c7-f70ac9b021cf',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.LINKS,
    name: 'domainName',
    label: 'Domain Name',
    defaultValue: {
      primaryLinkUrl: "''",
      secondaryLinks: [],
      primaryLinkLabel: "''",
    },
    description:
      'The company website URL. We use this url to fetch the company icon',
    icon: 'IconLink',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: true,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-0c28-43d8-8ba5-3659924d3489',
  }),
  employees: getFlatFieldMetadataMock({
    id: '721d26f0-238d-4d55-a1a2-62f915631c4d',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.NUMBER,
    name: 'employees',
    label: 'Employees',
    defaultValue: null,
    description: 'Number of employees in the company',
    icon: 'IconUsers',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-8965-464a-8a75-74bafc152a0b',
  }),
  linkedinLink: getFlatFieldMetadataMock({
    id: '6acb80a0-dab8-4d97-a0c8-15e4a495fb54',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.LINKS,
    name: 'linkedinLink',
    label: 'Linkedin',
    defaultValue: {
      primaryLinkUrl: "''",
      secondaryLinks: [],
      primaryLinkLabel: "''",
    },
    description: 'The company Linkedin account',
    icon: 'IconBrandLinkedin',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-ebeb-4beb-b9ad-6848036fb451',
  }),
  xLink: getFlatFieldMetadataMock({
    id: 'fc630bbb-aa2c-4554-aa4f-9afc0b0567f9',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.LINKS,
    name: 'xLink',
    label: 'X',
    defaultValue: {
      primaryLinkUrl: "''",
      secondaryLinks: [],
      primaryLinkLabel: "''",
    },
    description: 'The company Twitter/X account',
    icon: 'IconBrandX',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-6f64-4fd9-9580-9c1991c7d8c3',
  }),
  annualRecurringRevenue: getFlatFieldMetadataMock({
    id: '1e34d871-3e1a-4903-850e-1e4bc6b1d72b',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.CURRENCY,
    name: 'annualRecurringRevenue',
    label: 'ARR',
    defaultValue: { amountMicros: null, currencyCode: "''" },
    description:
      'Annual Recurring Revenue: The actual or estimated annual revenue of the company',
    icon: 'IconMoneybag',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-602a-495c-9776-f5d5b11d227b',
  }),
  address: getFlatFieldMetadataMock({
    id: '1bd4dc61-e644-4a9e-8899-cacdf43571a1',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.ADDRESS,
    name: 'address',
    label: 'Address',
    defaultValue: {
      addressLat: null,
      addressLng: null,
      addressCity: "''",
      addressState: "''",
      addressCountry: "''",
      addressStreet1: "''",
      addressStreet2: "''",
      addressPostcode: "''",
    },
    description: 'Address of the company',
    icon: 'IconMap',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-c5ce-4adc-b7b6-9c0979fc55e7',
  }),
  idealCustomerProfile: getFlatFieldMetadataMock({
    id: '8b75a4f1-dc7d-4fa3-b778-616ab9128c31',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.BOOLEAN,
    name: 'idealCustomerProfile',
    label: 'ICP',
    defaultValue: false,
    description:
      'Ideal Customer Profile:  Indicates whether the company is the most suitable and valuable customer for you',
    icon: 'IconTarget',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-ba6b-438a-8213-2c5ba28d76a2',
  }),
  position: getFlatFieldMetadataMock({
    id: 'ed081dac-ff61-4fe1-bc2c-073644b61c28',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.POSITION,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Company record position',
    icon: 'IconHierarchy2',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-9b4e-462b-991d-a0ee33326454',
  }),
  createdBy: getFlatFieldMetadataMock({
    id: 'dbbddd40-a72b-47fe-9ecf-9bdd4282369a',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.ACTOR,
    name: 'createdBy',
    label: 'Created by',
    defaultValue: {
      name: "'System'",
      source: "'MANUAL'",
      workspaceMemberId: null,
    },
    description: 'The creator of the record',
    icon: 'IconCreativeCommonsSa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-fabc-451d-ab7d-412170916baa',
  }),
  searchVector: getFlatFieldMetadataMock({
    id: 'b2850ac5-d368-44ab-bc79-b1bf7212e5fb',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.TS_VECTOR,
    name: 'searchVector',
    label: 'Search vector',
    defaultValue: null,
    description: 'Field used for full-text search',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '85c71601-72f9-4b7b-b343-d46100b2c74d',
  }),
  id: getFlatFieldMetadataMock({
    id: '982dff40-66c9-4b9b-b3ec-8fa7076ea3a6',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: 'e2f65a26-0210-4f22-954b-7d448abbdb28',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: '26518091-a31b-4716-8627-4e2d25bc0e60',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: '29ba1ee7-fc21-441c-8acc-45d9e56751e3',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  people: getFlatFieldMetadataMock({
    id: 'b0563539-f027-40c5-a14c-ee7a25ff6fd9',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'people',
    label: 'People',
    defaultValue: null,
    description: 'People linked to the company.',
    icon: 'IconUsers',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'ee247ca6-fdaa-4a56-87a2-730cf84f5f29',
    relationTargetObjectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    universalIdentifier: '20202020-3213-4ddf-9494-6422bcff8d7c',
  }),
  accountOwner: getFlatFieldMetadataMock({
    id: '86c6692b-bed5-4ef1-bad0-657e56a85eba',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'accountOwner',
    label: 'Account Owner',
    defaultValue: null,
    description:
      'Your team member responsible for managing the company account',
    icon: 'IconUserCircle',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'accountOwnerId',
    },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '1fe5453f-6042-4370-b388-c9a198bd0ab4',
    relationTargetObjectMetadataId: '7d8264db-2b55-4b74-81ff-b7064ed43840',
    universalIdentifier: '20202020-95b8-4e10-9881-edb5d4765f9d',
  }),
  taskTargets: getFlatFieldMetadataMock({
    id: '4f9138da-cd36-4df4-98f9-ebabe036b141',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'taskTargets',
    label: 'Tasks',
    defaultValue: null,
    description: 'Tasks tied to the company',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'ec11b025-1476-4e84-81c5-cf5b5c776edc',
    relationTargetObjectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    universalIdentifier: '20202020-cb17-4a61-8f8f-3be6730480de',
  }),
  noteTargets: getFlatFieldMetadataMock({
    id: '56b9dc8a-0379-42cf-ab31-8db7061f5a2a',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'noteTargets',
    label: 'Notes',
    defaultValue: null,
    description: 'Notes tied to the company',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'd1d3f9eb-1447-4adb-bc2b-f133bc58ac35',
    relationTargetObjectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    universalIdentifier: '20202020-bae0-4556-a74a-a9c686f77a88',
  }),
  opportunities: getFlatFieldMetadataMock({
    id: '3eda8c8e-74e4-401f-bb0e-470db5b267e6',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'opportunities',
    label: 'Opportunities',
    defaultValue: null,
    description: 'Opportunities linked to the company.',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '512890f1-4da0-4b96-bb71-5ccabefb82e7',
    relationTargetObjectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    universalIdentifier: '20202020-add3-4658-8e23-d70dccb6d0ec',
  }),
  favorites: getFlatFieldMetadataMock({
    id: '72415216-fed4-450b-aa00-691e37718b01',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'favorites',
    label: 'Favorites',
    defaultValue: null,
    description: 'Favorites linked to the company',
    icon: 'IconHeart',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '9a11532c-6839-46ed-a2f5-ed03f88b86f6',
    relationTargetObjectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    universalIdentifier: '20202020-4d1d-41ac-b13b-621631298d55',
  }),
  attachments: getFlatFieldMetadataMock({
    id: '44a572c5-d620-47f5-943a-346ae967e99e',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'attachments',
    label: 'Attachments',
    defaultValue: null,
    description: 'Attachments linked to the company',
    icon: 'IconFileImport',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '0bacf73b-f45b-4683-85b4-3e812e6228bf',
    relationTargetObjectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    universalIdentifier: '20202020-c1b5-4120-b0f0-987ca401ed53',
  }),
  timelineActivities: getFlatFieldMetadataMock({
    id: 'cc78390f-f570-4c2c-9f19-2a8fef67f4f6',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.RELATION,
    name: 'timelineActivities',
    label: 'Timeline Activities',
    defaultValue: null,
    description: 'Timeline Activities linked to the company',
    icon: 'IconIconTimelineEvent',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'fd8cabe5-7dc8-4d6a-8053-43434488b3e4',
    relationTargetObjectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    universalIdentifier: '20202020-0414-4daf-9c0d-64fe7b27f89f',
  }),
  tagline: getFlatFieldMetadataMock({
    id: 'f869f4ed-e440-486a-8392-be33ab327cf4',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.TEXT,
    name: 'tagline',
    label: 'Tagline',
    defaultValue: "''",
    description: null,
    icon: 'IconAdCircle',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: 'f869f4ed-e440-486a-8392-be33ab327cf4',
  }),
  introVideo: getFlatFieldMetadataMock({
    id: '339b52b7-adfb-4bd3-ae42-0697da92c0fa',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.LINKS,
    name: 'introVideo',
    label: 'Intro Video',
    defaultValue: {
      primaryLinkUrl: "''",
      secondaryLinks: [],
      primaryLinkLabel: "''",
    },
    description: null,
    icon: 'IconVideo',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '339b52b7-adfb-4bd3-ae42-0697da92c0fa',
  }),
  workPolicy: getFlatFieldMetadataMock({
    id: '74c546c1-b183-41d0-ac20-aecde83bf674',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.MULTI_SELECT,
    name: 'workPolicy',
    label: 'Work Policy',
    defaultValue: null,
    description: null,
    icon: 'IconHome',
    standardOverrides: null,
    options: [
      {
        id: '325240d6-8c67-4fb2-bb02-51e9de4cd6be',
        color: 'green',
        label: 'On-Site',
        value: 'ON_SITE',
        position: 0,
      },
      {
        id: 'dcf5b58a-945f-4e21-9146-e5ed6adebd32',
        color: 'turquoise',
        label: 'Hybrid',
        value: 'HYBRID',
        position: 1,
      },
      {
        id: '0c17887a-8f49-48ae-9d6b-1034f2b2fc03',
        color: 'sky',
        label: 'Remote Work',
        value: 'REMOTE_WORK',
        position: 2,
      },
    ],
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '74c546c1-b183-41d0-ac20-aecde83bf674',
  }),
  visaSponsorship: getFlatFieldMetadataMock({
    id: '5e48697e-a3d0-4faa-b79c-bddd8c7ae17f',
    objectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    type: FieldMetadataType.BOOLEAN,
    name: 'visaSponsorship',
    label: 'Visa Sponsorship',
    defaultValue: false,
    description: null,
    icon: 'IconBrandVisa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: true,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '5e48697e-a3d0-4faa-b79c-bddd8c7ae17f',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
