import { FeatureFlagKey } from 'src/engine/core-modules/feature-flag/enums/feature-flag-key.enum';

type FeatureFlagMetadata = {
  label: string;
  description: string;
  imagePath?: string;
};

export type PublicFeatureFlag = {
  key: FeatureFlagKey;
  metadata: FeatureFlagMetadata;
};

export const PUBLIC_FEATURE_FLAGS: PublicFeatureFlag[] = [
  {
    key: FeatureFlagKey.IS_JUNCTION_RELATIONS_ENABLED,
    metadata: {
      label: 'Junction Relations',
      description:
        'Enable many-to-many relations through junction tables configuration',
    },
  },
  {
    key: FeatureFlagKey.IS_ROW_LEVEL_PERMISSION_PREDICATES_ENABLED,
    metadata: {
      label: 'Row Level Permissions',
      description: 'Enable row level permission',
      imagePath:
        'https://twenty.com/images/lab/is-row-level-permission-predicates-enabled.png',
    },
  },
  {
    key: FeatureFlagKey.IS_SSE_DB_EVENTS_ENABLED,
    metadata: {
      label: 'Real-Time',
      description: 'See all updates without reloading the page',
      imagePath: 'https://twenty.com/images/lab/is-real-time-enabled.png',
    },
  },
  ...(process.env.CLOUDFLARE_API_KEY
    ? [
        // {
        // Here you can add cloud only feature flags
        // },
      ]
    : []),
];
