import { FieldMetadataType } from 'twenty-shared/types';

export const POSTGRES_DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE = '';

export const DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE = '';

export const DEFAULT_ARRAY_FIELD_NULL_EQUIVALENT_VALUE = [];

export const POSTGRES_DEFAULT_ARRAY_FIELD_NULL_EQUIVALENT_VALUE = '{}';

const DEFAULT_ADDRESS_FIELD_NULL_EQUIVALENT_VALUE = {
  addressStreet1: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  addressStreet2: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  addressCity: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  addressState: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  addressCountry: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  addressPostcode: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
};

const DEFAULT_EMAILS_FIELD_NULL_EQUIVALENT_VALUE = {
  primaryEmail: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  additionalEmails: DEFAULT_ARRAY_FIELD_NULL_EQUIVALENT_VALUE,
};

const DEFAULT_LINKS_FIELD_NULL_EQUIVALENT_VALUE = {
  primaryLinkUrl: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  primaryLinkLabel: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  secondaryLinks: DEFAULT_ARRAY_FIELD_NULL_EQUIVALENT_VALUE,
};

const DEFAULT_PHONES_FIELD_NULL_EQUIVALENT_VALUE = {
  primaryPhoneNumber: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  primaryPhoneCountryCode: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  primaryPhoneCallingCode: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  additionalPhones: DEFAULT_ARRAY_FIELD_NULL_EQUIVALENT_VALUE,
};

const DEFAULT_FULL_NAME_FIELD_NULL_EQUIVALENT_VALUE = {
  firstName: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
  lastName: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
};

const DEFAULT_ACTOR_FIELD_NULL_EQUIVALENT_VALUE = {
  name: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
};

const DEFAULT_RICH_TEXT_V2_FIELD_NULL_EQUIVALENT_VALUE = {
  markdown: DEFAULT_TEXT_FIELD_NULL_EQUIVALENT_VALUE,
};

export const DEFAULT_COMPOSITE_FIELDS_NULL_EQUIVALENT_VALUE: Partial<
  Record<FieldMetadataType, Record<string, unknown>>
> = {
  [FieldMetadataType.ADDRESS]: DEFAULT_ADDRESS_FIELD_NULL_EQUIVALENT_VALUE,
  [FieldMetadataType.EMAILS]: DEFAULT_EMAILS_FIELD_NULL_EQUIVALENT_VALUE,
  [FieldMetadataType.LINKS]: DEFAULT_LINKS_FIELD_NULL_EQUIVALENT_VALUE,
  [FieldMetadataType.PHONES]: DEFAULT_PHONES_FIELD_NULL_EQUIVALENT_VALUE,
  [FieldMetadataType.FULL_NAME]: DEFAULT_FULL_NAME_FIELD_NULL_EQUIVALENT_VALUE,
  [FieldMetadataType.ACTOR]: DEFAULT_ACTOR_FIELD_NULL_EQUIVALENT_VALUE,
  [FieldMetadataType.RICH_TEXT_V2]:
    DEFAULT_RICH_TEXT_V2_FIELD_NULL_EQUIVALENT_VALUE,
};
