import { FieldMetadataType } from 'twenty-shared/types';

import { type WorkspaceMigration } from 'src/engine/workspace-manager/workspace-migration/workspace-migration-builder/types/workspace-migration.type';

export const ADD_MISSING_SYSTEM_FIELDS_TO_STANDARD_OBJECTS_1771420702241 = {
  applicationUniversalIdentifier: '20202020-64aa-4b6f-b003-9c74b97cee20',
  actions: [
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'cef8f62c-cd46-4444-8cbb-17d463b7464a',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Attachment record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-bd3d-4c60-8dca-571c71d4447a',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'e7b42835-cb2e-4456-8558-9225362aa52d',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-bd3d-4c60-8dca-571c71d4447a',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"name\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'b80db15d-8dc2-4f47-a072-15030941a9d1',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-0408-4f38-b8a8-4d5e3e26e24d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '11aaa404-f04b-421d-a451-c453bf77cc78',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-0408-4f38-b8a8-4d5e3e26e24d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '72a27e60-3542-46dc-90db-684d79bd7f11',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Blocklist record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-0408-4f38-b8a8-4d5e3e26e24d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '5fa758da-30b4-412e-8a4f-975f2848ce60',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-0408-4f38-b8a8-4d5e3e26e24d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"handle\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '8daa2bc8-bce2-4309-8a48-b929f3ee2c34',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-491b-4aaa-9825-afd1bae6ae00',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '55d810d2-fe47-44b4-b1de-b9c32113b695',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-491b-4aaa-9825-afd1bae6ae00',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '4fa18346-bb2b-49b0-ab35-23df86eed1c8',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Calendar channel event association record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-491b-4aaa-9825-afd1bae6ae00',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '1844a9cf-6d35-46d7-99ba-011626a6d71b',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-491b-4aaa-9825-afd1bae6ae00',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"eventExternalId\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '664db1a0-76f4-4429-8452-f8e250ab7545',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-e8f2-40e1-a39c-c0e0039c5034',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '6a397eab-3700-4b08-9eb9-d16b61876193',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-e8f2-40e1-a39c-c0e0039c5034',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '566609c9-1c8b-4899-91bb-0af140a89004',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Calendar channel record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-e8f2-40e1-a39c-c0e0039c5034',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'bc9a982c-c314-49d6-818a-2661ce7e918f',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-e8f2-40e1-a39c-c0e0039c5034',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"handle\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '9e9ec14d-b889-448e-afe5-40e407be11d1',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a1c3-47a6-9732-27e5b1e8436d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'a2c6efda-06bf-418e-808a-dac9fd64ab58',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a1c3-47a6-9732-27e5b1e8436d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'fcfa672c-ce6d-4fc1-b978-db58a4cc14f4',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Calendar event participant record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a1c3-47a6-9732-27e5b1e8436d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'c9dccf32-64ea-433e-a9a7-09993343bae0',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a1c3-47a6-9732-27e5b1e8436d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"handle\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '664a9500-2641-4caa-8d95-069807bb2eb4',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-8f1d-4eef-9f85-0d1965e27221',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '1081c196-d675-4801-b9e1-7d8637b48eab',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-8f1d-4eef-9f85-0d1965e27221',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'e9488e9a-0abe-4500-8c1d-bfbd6b8cffad',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Calendar event record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-8f1d-4eef-9f85-0d1965e27221',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'b9e7825c-d491-4414-b904-910c00b5b93b',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-8f1d-4eef-9f85-0d1965e27221',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"title\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'e09c2463-9ca6-4004-97ce-6039e3161a5d',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-977e-46b2-890b-c3002ddfd5c5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '0a84c0e1-f9fc-47d5-8ac9-58538e50a9f9',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-977e-46b2-890b-c3002ddfd5c5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '66b7bc3e-c99e-42b6-82e6-6f43142c0f2f',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Connected account record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-977e-46b2-890b-c3002ddfd5c5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '140767fe-0aa4-4573-a0bd-67cb657c9452',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-977e-46b2-890b-c3002ddfd5c5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"handle\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '6440dc3d-fa50-49cc-abd3-98eeccd79288',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-ab56-4e05-92a3-e2414a499860',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '6c117b1a-0470-499b-8fcb-d9059eafbd43',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-ab56-4e05-92a3-e2414a499860',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'cbb27ea1-5cf8-4fed-9e0a-e4152815bd6e',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-ab56-4e05-92a3-e2414a499860',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '1ec58922-7789-4832-a583-ec97f766f433',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-7cf8-401f-8211-a9587d27fd2d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '6a53edc6-0ef2-4c35-9065-f91c4ddf7f01',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-7cf8-401f-8211-a9587d27fd2d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'c5bb12e1-0cc3-428f-89f0-4c8747239ac3',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-7cf8-401f-8211-a9587d27fd2d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"name\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '6e52bde4-ed41-4462-aa70-121e496270b4',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3f6b-4425-80ab-e468899ab4b2',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '7822dcc0-ee40-4af0-a6fe-f10a14e72b24',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3f6b-4425-80ab-e468899ab4b2',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '06c5052d-3369-4d6d-8eaa-f9780eddb1fd',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Message record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3f6b-4425-80ab-e468899ab4b2',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '529b6008-4a12-4d48-bbc3-26a3f199bafd',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3f6b-4425-80ab-e468899ab4b2',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"subject\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'b7de8fcc-a7c6-4122-b3fa-1fcf8f30931c',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fe8c-40bc-a681-b80b771449b7',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '88bb6ff1-b8a1-4313-95d4-7879acca0b93',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fe8c-40bc-a681-b80b771449b7',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'bc8a36af-8b9c-4548-a0da-c90e899e7243',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Message Channel record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fe8c-40bc-a681-b80b771449b7',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '5e84794c-6f14-4bdf-81a6-76ee11cda51f',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fe8c-40bc-a681-b80b771449b7',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"handle\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'ce7dc96f-dd33-4bce-9505-cbd381440cec',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-ad1e-4127-bccb-d83ae04d2ccb',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '334d2ad6-4bc4-4b51-9c92-8ad57652475e',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-ad1e-4127-bccb-d83ae04d2ccb',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '45d1e083-90d6-4507-b68a-454a9dc3a540',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Message channel message association record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-ad1e-4127-bccb-d83ae04d2ccb',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'edddd409-d9f0-4b93-8e3f-37faef6a3387',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-ad1e-4127-bccb-d83ae04d2ccb',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"messageExternalId\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'bfe19f84-b640-4ce3-b771-4e7bf18bad14',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-4955-4fd9-8e59-2dbd373f2a46',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '7ec7eea8-8715-4656-a602-3cb4256aaca1',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-4955-4fd9-8e59-2dbd373f2a46',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '5317d4f4-12c5-469d-8e47-0f3b2ffc95b4',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Message Folder record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-4955-4fd9-8e59-2dbd373f2a46',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '5f2d3937-bafd-4d71-b4cb-b34037efd2e1',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-4955-4fd9-8e59-2dbd373f2a46',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"name\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'e0e6aa04-6ad5-4d12-8799-6febf00452c1',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a433-4456-aa2d-fd9cb26b774a',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '6c90fd49-22b8-4f91-b4eb-4b9af630e988',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a433-4456-aa2d-fd9cb26b774a',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'f49ca74e-dcdf-445d-a707-3c22869b4e6c',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Message Participant record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a433-4456-aa2d-fd9cb26b774a',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '80fec74f-cda7-46bd-ae37-8998bd4f992b',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-a433-4456-aa2d-fd9cb26b774a',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"handle\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'b50ce369-9905-46d9-b95b-5e4034d252aa',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-849a-4c3e-84f5-a25a7d802271',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '20fbafd0-0a16-4785-b5a6-f1ef45ef304c',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-849a-4c3e-84f5-a25a7d802271',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '7490a440-7a62-466e-ba93-75a2f2edfb1e',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Message Thread record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-849a-4c3e-84f5-a25a7d802271',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'c63e091f-6528-4657-ad2a-b0a158f9e483',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-849a-4c3e-84f5-a25a7d802271',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '820a3163-bb7d-41bc-93d9-81a464559c48',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fff0-4b44-be82-bda313884400',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'a48c2bae-fe78-4d9d-bc37-f56d1a462121',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fff0-4b44-be82-bda313884400',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '082f7c9e-5ccd-4056-8748-a428f65fa6f6',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'NoteTarget record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fff0-4b44-be82-bda313884400',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '0cc32d0f-99ab-4fee-bf66-9e84bc8bce00',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-fff0-4b44-be82-bda313884400',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '65fe2a53-45e4-4225-9711-b827f55e51cc',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-5a9a-44e8-95df-771cd06d0fb1',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'bea3734f-aff2-49ed-9dc9-d4666a2e2178',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-5a9a-44e8-95df-771cd06d0fb1',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '4216c06a-498b-4111-9577-d9bcbccdda39',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'TaskTarget record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-5a9a-44e8-95df-771cd06d0fb1',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '8768a9c0-37c0-4465-b86d-c4c7f466ec23',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-5a9a-44e8-95df-771cd06d0fb1',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '8f66191f-927d-4a6d-a15f-d0ff8cfc5a6d',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-6736-4337-b5c4-8b39fae325a5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '81dc29fc-c872-4efd-bf31-d07872cd260e',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-6736-4337-b5c4-8b39fae325a5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'e245d799-3e4b-4c69-ab9a-6b7c91d71195',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'Timeline activity record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-6736-4337-b5c4-8b39fae325a5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'bc1d1b67-903a-4354-8272-4a6efc4cbe63',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-6736-4337-b5c4-8b39fae325a5',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: {
          generatedType: 'STORED',
          asExpression:
            "to_tsvector('simple', COALESCE(public.unaccent_immutable(\"name\"), ''))",
        },
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '5cea2f46-3779-4782-9fce-3062652e2dfd',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3319-4234-a34c-7f3b9d2e4d1f',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '017d3587-98bd-43ad-b5a6-cb8125105641',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3319-4234-a34c-7f3b9d2e4d1f',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'f4c5eb0a-8a86-49a2-a775-941eaad98fc9',
        type: FieldMetadataType.POSITION,
        name: 'position',
        label: 'Position',
        description: 'WorkflowAutomatedTrigger record position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: 0,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3319-4234-a34c-7f3b9d2e4d1f',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: 'dae934ca-bfca-4101-8211-8eae6e2b5513',
        type: FieldMetadataType.TS_VECTOR,
        name: 'searchVector',
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        isUnique: false,
        isUIReadOnly: false,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: null,
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3319-4234-a34c-7f3b9d2e4d1f',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '34f592a7-5c13-4c8b-8473-7bef00848b4e',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-d65d-4ab9-9344-d77bfb376a3d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '4f8777e6-c5eb-40c6-bb4c-ed9dcf0d81e9',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-d65d-4ab9-9344-d77bfb376a3d',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '4a3f26d1-033e-4d84-b23a-9adc2fd0c2a8',
        type: FieldMetadataType.ACTOR,
        name: 'createdBy',
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3319-4234-a34c-82d5c0e881a6',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
    {
      type: 'create',
      metadataName: 'fieldMetadata',
      flatEntity: {
        universalIdentifier: '29f84ad0-509f-4aef-9f9c-2691dd60cd87',
        type: FieldMetadataType.ACTOR,
        name: 'updatedBy',
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        isUnique: false,
        isUIReadOnly: true,
        isLabelSyncedWithName: false,
        standardOverrides: null,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
        options: null,
        morphId: null,
        createdAt: '2026-02-18T13:18:21.997Z',
        updatedAt: '2026-02-18T13:18:21.997Z',
        applicationUniversalIdentifier: '89590676-196d-4bc4-a3f5-1f068192068e',
        objectMetadataUniversalIdentifier:
          '20202020-3319-4234-a34c-82d5c0e881a6',
        relationTargetObjectMetadataUniversalIdentifier: null,
        relationTargetFieldMetadataUniversalIdentifier: null,
        universalSettings: null,
      },
    },
  ],
} as const satisfies WorkspaceMigration;
