import { getRecordsFromRecordConnection } from '@/object-record/cache/utils/getRecordsFromRecordConnection';
import { type RecordGqlConnectionEdgesRequired } from '@/object-record/graphql/types/RecordGqlConnectionEdgesRequired';
import { type ObjectRecord } from '@/object-record/types/ObjectRecord';

import { type FieldMetadataType } from 'twenty-shared/types';
import { getMockObjectMetadataItemOrThrow } from '~/testing/utils/getMockObjectMetadataItemOrThrow';

export const peopleQueryResult = {
  people: {
    __typename: 'PersonConnection',
    totalCount: 16,
    pageInfo: {
      __typename: 'PageInfo',
      hasNextPage: false,
      hasPreviousPage: false,
      startCursor:
        'WzAsICJkYTNjMmM0Yi1kYTAxLTRiODEtOTczNC0yMjYwNjllYjRjZDAiXQ==',
      endCursor: 'WzE1LCAiMjAyMDIwMjAtMmQ0MC00ZTQ5LThkZjQtOWM2YTA0OTE5MWRmIl0=',
    },
    edges: [
      {
        __typename: 'PersonEdge',
        cursor: 'WzAsICJkYTNjMmM0Yi1kYTAxLTRiODEtOTczNC0yMjYwNjllYjRjZDAiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:52:46.814Z',
          city: 'ASd',
          phones: {
            primaryPhoneNumber: '781234562',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: 'da3c2c4b-da01-4b81-9734-226069eb4cd0',
          jobTitle: '',
          position: 0,
          email: 'asd.com',
          avatarUrl: null,
          emails: {
            primaryEmail: 'asd.com',
            additionalEmails: [],
          },
          intro: '',
          performanceRating: null,
          updatedAt: '2025-01-02T09:52:46.814Z',
          whatsapp: {
            primaryPhoneNumber: '',
            primaryPhoneCountryCode: '',
            primaryPhoneCallingCode: '',
            additionalPhones: [],
          },
          workPreference: null,
          name: {
            __typename: 'FullName',
            firstName: 'Test',
            lastName: 'Test',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
            context: null,
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 1,
            id: '20202020-3ec3-4fe3-8997-b76aa0bfa408',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Linkedin',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: 'Eutaw Street',
              addressStreet2: null,
              addressCity: 'Dublin',
              addressState: null,
              addressCountry: 'Ireland',
              addressPostcode: null,
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://linkedin.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
          testSelect: {
            __typename: 'Select',
            value: 'Option 1',
            label: 'Option 1',
          },
          testMultiSelect: {
            __typename: 'MultiSelect',
            values: [
              {
                __typename: 'Select',
                value: 'Option 1',
                label: 'Option 1',
              },
            ],
          },
          testRating: {
            __typename: 'Rating',
            value: 3,
          },
          testJson: {
            __typename: 'Json',
            value: {
              key: 'value',
            },
          },
          testActor: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzEsICIyMDIwMjAyMC0xYzBlLTQ5NGMtYTFiNi04NWIxYzZmZWZhYTUiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-01T09:50:00.000Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '781234562',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-1c0e-494c-a1b6-85b1c6fefaa5',
          jobTitle: '',
          position: 1,
          email: 'christoph.calisto@linkedin.com',
          avatarUrl: null,
          emails: {
            primaryEmail: 'christoph.calisto@linkedin.com',
            additionalEmails: [],
          },
          intro: '',
          performanceRating: null,
          updatedAt: '2025-01-01T09:50:00.000Z',
          whatsapp: {
            primaryPhoneNumber: '',
            primaryPhoneCountryCode: '',
            primaryPhoneCallingCode: '',
            additionalPhones: [],
          },
          workPreference: null,
          name: {
            __typename: 'FullName',
            firstName: 'Christoph',
            lastName: 'Callisto',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
            context: null,
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 1,
            id: '20202020-3ec3-4fe3-8997-b76aa0bfa408',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Linkedin',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: 'Eutaw Street',
              addressStreet2: null,
              addressCity: 'Dublin',
              addressState: null,
              addressCountry: 'Ireland',
              addressPostcode: null,
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://linkedin.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
          testSelect: {
            __typename: 'Select',
            value: 'Option 1',
            label: 'Option 1',
          },
          testMultiSelect: {
            __typename: 'MultiSelect',
            values: [
              {
                __typename: 'Select',
                value: 'Option 1',
                label: 'Option 1',
              },
            ],
          },
          testRating: {
            __typename: 'Rating',
            value: 3,
          },
          testJson: {
            __typename: 'Json',
            value: {
              key: 'value',
            },
          },
          testActor: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzIsICIyMDIwMjAyMC1hYzczLTQ3OTctODI0ZS04N2ExZjVhZWE5ZTAiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Los Angeles',
          phones: {
            primaryPhoneNumber: '781234576',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-ac73-4797-824e-87a1f5aea9e0',
          jobTitle: '',
          position: 2,
          email: 'sylvie.palmer@linkedin.com',
          name: {
            __typename: 'FullName',
            firstName: 'Sylvie',
            lastName: 'Palmer',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 1,
            id: '20202020-3ec3-4fe3-8997-b76aa0bfa408',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Linkedin',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: 'Eutaw Street',
              addressStreet2: null,
              addressCity: 'Dublin',
              addressState: null,
              addressCountry: 'Ireland',
              addressPostcode: null,
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://linkedin.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzMsICIyMDIwMjAyMC1mNTE3LTQyZmQtODBhZS0xNDE3M2IzYjcwYWUiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '781234545',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-f517-42fd-80ae-14173b3b70ae',
          jobTitle: '',
          position: 3,
          email: 'christopher.gonzalez@anthropic.com',
          name: {
            __typename: 'FullName',
            firstName: 'Christopher',
            lastName: 'Gonzalez',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 3,
            id: '20202020-0713-40a5-8216-82802401d33e',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Anthropic',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '548 Market Street',
              addressStreet2: null,
              addressCity: 'San Francisco',
              addressState: null,
              addressCountry: 'United States',
              addressPostcode: '94104',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://anthropic.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzQsICIyMDIwMjAyMC1lZWUxLTQ2OTAtYWQyYy04NjE5ZTViNTZhMmUiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Los Angeles',
          phones: {
            primaryPhoneNumber: '781234587',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-eee1-4690-ad2c-8619e5b56a2e',
          jobTitle: '',
          position: 4,
          email: 'ashley.parker@anthropic.com',
          name: {
            __typename: 'FullName',
            firstName: 'Ashley',
            lastName: 'Parker',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 3,
            id: '20202020-0713-40a5-8216-82802401d33e',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Anthropic',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '548 Market Street',
              addressStreet2: null,
              addressCity: 'San Francisco',
              addressState: null,
              addressCountry: 'United States',
              addressPostcode: '94104',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://anthropic.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzUsICIyMDIwMjAyMC02Nzg0LTQ0NDktYWZkZi1kYzYyY2I4NzAyZjIiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '781234599',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-6784-4449-afdf-dc62cb8702f2',
          jobTitle: '',
          position: 5,
          email: 'nicholas.wright@microsoft.com',
          name: {
            __typename: 'FullName',
            firstName: 'Nicholas',
            lastName: 'Wright',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 4,
            id: '20202020-ed89-413a-b31a-962986e67bb4',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Microsoft',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: null,
              addressStreet2: null,
              addressCity: null,
              addressState: null,
              addressCountry: null,
              addressPostcode: null,
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://microsoft.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzYsICIyMDIwMjAyMC00OTBmLTQ0NjYtODM5MS03MzNjZmQ2NmEwYzgiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'New York',
          phones: {
            primaryPhoneNumber: '781234572',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-490f-4466-8391-733cfd66a0c8',
          jobTitle: '',
          position: 6,
          email: 'isabella.scott@microsoft.com',
          name: {
            __typename: 'FullName',
            firstName: 'Isabella',
            lastName: 'Scott',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 4,
            id: '20202020-ed89-413a-b31a-962986e67bb4',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Microsoft',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: null,
              addressStreet2: null,
              addressCity: null,
              addressState: null,
              addressCountry: null,
              addressPostcode: null,
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://microsoft.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzcsICIyMDIwMjAyMC04MGYxLTRkZmYtYjU3MC1hNzQ5NDI1MjhkZTMiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '781234582',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-80f1-4dff-b570-a74942528de3',
          jobTitle: '',
          position: 7,
          email: 'matthew.green@microsoft.com',
          name: {
            __typename: 'FullName',
            firstName: 'Matthew',
            lastName: 'Green',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 4,
            id: '20202020-ed89-413a-b31a-962986e67bb4',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Microsoft',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: null,
              addressStreet2: null,
              addressCity: null,
              addressState: null,
              addressCountry: null,
              addressPostcode: null,
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://microsoft.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzgsICIyMDIwMjAyMC0zMzhiLTQ2ZGYtODgxMS1mYTA4YzdkMTlkMzUiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'New York',
          phones: {
            primaryPhoneNumber: '781234569',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-338b-46df-8811-fa08c7d19d35',
          jobTitle: '',
          position: 8,
          email: 'elizabeth.baker@airbnb.com',
          name: {
            __typename: 'FullName',
            firstName: 'Elizabeth',
            lastName: 'Baker',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 5,
            id: '20202020-171e-4bcc-9cf7-43448d6fb278',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Airbnb',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '888 Brannan St',
              addressStreet2: null,
              addressCity: 'San Francisco',
              addressState: 'CA',
              addressCountry: 'United States',
              addressPostcode: '94103',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://airbnb.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzksICIyMDIwMjAyMC02NGFkLTRiMGUtYmJmZC1lOWZkNzk1YjcwMTYiXQ==',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'San Francisco',
          phones: {
            primaryPhoneNumber: '781234962',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-64ad-4b0e-bbfd-e9fd795b7016',
          jobTitle: '',
          position: 9,
          email: 'christopher.nelson@airbnb.com',
          name: {
            __typename: 'FullName',
            firstName: 'Christopher',
            lastName: 'Nelson',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 5,
            id: '20202020-171e-4bcc-9cf7-43448d6fb278',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Airbnb',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '888 Brannan St',
              addressStreet2: null,
              addressCity: 'San Francisco',
              addressState: 'CA',
              addressCountry: 'United States',
              addressPostcode: '94103',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://airbnb.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzEwLCAiMjAyMDIwMjAtNWQ1NC00MWI3LWJhMzYtZjBkMjBlMTQxN2FlIl0=',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'New York',
          phones: {
            primaryPhoneNumber: '781234502',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-5d54-41b7-ba36-f0d20e1417ae',
          jobTitle: '',
          position: 10,
          email: 'avery.carter@airbnb.com',
          name: {
            __typename: 'FullName',
            firstName: 'Avery',
            lastName: 'Carter',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 5,
            id: '20202020-171e-4bcc-9cf7-43448d6fb278',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Airbnb',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '888 Brannan St',
              addressStreet2: null,
              addressCity: 'San Francisco',
              addressState: 'CA',
              addressCountry: 'United States',
              addressPostcode: '94103',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://airbnb.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzExLCAiMjAyMDIwMjAtNjIzZC00MWZlLTkyZTctZGQ0NWI3YzU2OGUxIl0=',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Los Angeles',
          phones: {
            primaryPhoneNumber: '781234563',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-623d-41fe-92e7-dd45b7c568e1',
          jobTitle: '',
          position: 11,
          email: 'ethan.mitchell@google.com',
          name: {
            __typename: 'FullName',
            firstName: 'Ethan',
            lastName: 'Mitchell',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 6,
            id: '20202020-c21e-4ec2-873b-de4264d89025',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Google',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '760 Market St',
              addressStreet2: 'Floor 10',
              addressCity: 'San Francisco',
              addressState: null,
              addressCountry: 'United States',
              addressPostcode: '94102',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://google.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzEyLCAiMjAyMDIwMjAtMmQ0MC00ZTQ5LThkZjQtOWM2YTA0OTE5MGVmIl0=',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '781234542',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-2d40-4e49-8df4-9c6a049190ef',
          jobTitle: '',
          position: 12,
          email: 'madison.perez@google.com',
          name: {
            __typename: 'FullName',
            firstName: 'Madison',
            lastName: 'Perez',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 6,
            id: '20202020-c21e-4ec2-873b-de4264d89025',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Google',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '760 Market St',
              addressStreet2: 'Floor 10',
              addressCity: 'San Francisco',
              addressState: null,
              addressCountry: 'United States',
              addressPostcode: '94102',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://google.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzEzLCAiMjAyMDIwMjAtMmQ0MC00ZTQ5LThkZjQtOWM2YTA0OTE5MGRmIl0=',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '782234562',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-2d40-4e49-8df4-9c6a049190df',
          jobTitle: '',
          position: 13,
          email: 'bertrand.voulzy@google.com',
          name: {
            __typename: 'FullName',
            firstName: 'Bertrand',
            lastName: 'Voulzy',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 6,
            id: '20202020-c21e-4ec2-873b-de4264d89025',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Google',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '760 Market St',
              addressStreet2: 'Floor 10',
              addressCity: 'San Francisco',
              addressState: null,
              addressCountry: 'United States',
              addressPostcode: '94102',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://google.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzE0LCAiMjAyMDIwMjAtMmQ0MC00ZTQ5LThkZjQtOWM2YTA0OTE5MWRlIl0=',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '781274562',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-2d40-4e49-8df4-9c6a049191de',
          jobTitle: '',
          position: 14,
          email: 'louis.duss@google.com',
          name: {
            __typename: 'FullName',
            firstName: 'Louis',
            lastName: 'Duss',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 6,
            id: '20202020-c21e-4ec2-873b-de4264d89025',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Google',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '760 Market St',
              addressStreet2: 'Floor 10',
              addressCity: 'San Francisco',
              addressState: null,
              addressCountry: 'United States',
              addressPostcode: '94102',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://google.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
      {
        __typename: 'PersonEdge',
        cursor: 'WzE1LCAiMjAyMDIwMjAtMmQ0MC00ZTQ5LThkZjQtOWM2YTA0OTE5MWRmIl0=',
        node: {
          __typename: 'Person',
          deletedAt: null,
          createdAt: '2025-01-02T09:48:36.193Z',
          city: 'Seattle',
          phones: {
            primaryPhoneNumber: '781239562',
            primaryPhoneCountryCode: 'FR',
            primaryPhoneCallingCode: '+33',
            additionalPhones: [],
          },
          id: '20202020-2d40-4e49-8df4-9c6a049191df',
          jobTitle: '',
          position: 15,
          email: 'lorie.vladim@google.com',
          name: {
            __typename: 'FullName',
            firstName: 'Lorie',
            lastName: 'Vladim',
          },
          noteTargets: {
            __typename: 'NoteTargetConnection',
            edges: [],
          },
          taskTargets: {
            __typename: 'TaskTargetConnection',
            edges: [],
          },
          linkedinLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: null,
            name: '',
          },
          xLink: {
            __typename: 'Links',
            primaryLinkUrl: '',
            primaryLinkLabel: '',
            secondaryLinks: [],
          },
          company: {
            __typename: 'Company',
            employees: null,
            idealCustomerProfile: false,
            position: 6,
            id: '20202020-c21e-4ec2-873b-de4264d89025',
            updatedAt: '2025-01-02T10:48:36.193Z',
            accountOwnerId: null,
            name: 'Google',
            createdAt: '2025-01-02T09:48:36.193Z',
            address: {
              __typename: 'Address',
              addressStreet1: '760 Market St',
              addressStreet2: 'Floor 10',
              addressCity: 'San Francisco',
              addressState: null,
              addressCountry: 'United States',
              addressPostcode: '94102',
              addressLat: null,
              addressLng: null,
            },
            annualRecurringRevenue: {
              __typename: 'Currency',
              amountMicros: null,
              currencyCode: '',
            },
            domainName: {
              __typename: 'Links',
              primaryLinkUrl: 'https://google.com',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            linkedinLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
            createdBy: {
              __typename: 'Actor',
              source: 'MANUAL',
              workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
              name: 'Tim Apple',
            },
            xLink: {
              __typename: 'Links',
              primaryLinkUrl: '',
              primaryLinkLabel: '',
              secondaryLinks: [],
            },
          },
        },
      },
    ],
  },
} satisfies { people: RecordGqlConnectionEdgesRequired };

export const allMockPersonRecords = getRecordsFromRecordConnection({
  recordConnection: peopleQueryResult.people,
}) as ObjectRecord[];

export const getPeopleRecordConnectionMock = () => {
  const peopleMock = peopleQueryResult.people.edges.map((edge) => edge.node);

  return peopleMock;
};

export const getMockPersonObjectMetadataItem = () => {
  const personObjectMetadataItem = getMockObjectMetadataItemOrThrow('person');

  return personObjectMetadataItem;
};

export const getMockPersonFieldMetadataItem = (
  fieldMetadataType: FieldMetadataType,
  objectMetadataItem = getMockPersonObjectMetadataItem(),
) => {
  const result = objectMetadataItem.fields.find(
    (field) => field.type === fieldMetadataType,
  );
  if (!result) {
    throw new Error(
      `Person fieldmetadata item type ${fieldMetadataType} not found`,
    );
  }

  return result;
};

export const getMockPersonRecord = (
  overrides?: Partial<ObjectRecord>,
  index = 0,
) => {
  return {
    ...allMockPersonRecords[index],
    ...overrides,
  };
};

export const mockedEmptyPersonData = {
  id: 'ce7f0a37-88d7-4cd8-8b41-6721c57195b5',
  firstName: '',
  lastName: '',
  phone: null,
  email: null,
  city: null,
  createdBy: null,
  displayName: null,
  avatarUrl: null,
  createdAt: null,
  jobTitle: null,
  linkedinUrl: null,
  xUrl: null,
  _activityCount: null,
  company: null,
  deletedAt: null,
  __typename: 'Person',
};
