import { SETTINGS_ROLE_DETAIL_TABS } from '@/settings/roles/role/constants/SettingsRoleDetailTabs';
import { settingsDraftRoleFamilyState } from '@/settings/roles/states/settingsDraftRoleFamilyState';
import { settingsPersistedRoleFamilyState } from '@/settings/roles/states/settingsPersistedRoleFamilyState';
import { activeTabIdComponentState } from '@/ui/layout/tab-list/states/activeTabIdComponentState';
import { useSetRecoilComponentStateV2 } from '@/ui/utilities/state/jotai/hooks/useSetRecoilComponentStateV2';
import { t } from '@lingui/core/macro';
import { useEffect, useState } from 'react';
import { useSetRecoilState } from 'recoil';

type SettingsRoleCreateEffectProps = {
  roleId: string;
};

export const SettingsRoleCreateEffect = ({
  roleId,
}: SettingsRoleCreateEffectProps) => {
  const setSettingsDraftRole = useSetRecoilState(
    settingsDraftRoleFamilyState(roleId),
  );

  const setSettingsPersistedRole = useSetRecoilState(
    settingsPersistedRoleFamilyState(roleId),
  );

  const setActiveTabId = useSetRecoilComponentStateV2(
    activeTabIdComponentState,
    SETTINGS_ROLE_DETAIL_TABS.COMPONENT_INSTANCE_ID + '-' + roleId,
  );

  const [isInitialized, setIsInitialized] = useState(false);

  useEffect(() => {
    if (isInitialized) {
      return;
    }

    setActiveTabId(SETTINGS_ROLE_DETAIL_TABS.TABS_IDS.PERMISSIONS);

    const newRole = {
      id: roleId,
      label: t`Untitled role`,
      description: '',
      icon: 'IconUser',
      canUpdateAllSettings: true,
      canAccessAllTools: true,
      canReadAllObjectRecords: true,
      canUpdateAllObjectRecords: true,
      canSoftDeleteAllObjectRecords: true,
      canDestroyAllObjectRecords: true,
      canBeAssignedToUsers: true,
      canBeAssignedToAgents: true,
      canBeAssignedToApiKeys: true,
      isEditable: true,
      workspaceMembers: [],
      apiKeys: [],
      agents: [],
    };

    setSettingsPersistedRole(undefined);
    setSettingsDraftRole(newRole);
    setIsInitialized(true);
  }, [
    isInitialized,
    roleId,
    setActiveTabId,
    setSettingsDraftRole,
    setSettingsPersistedRole,
  ]);

  return null;
};
