import { SettingsLogicFunctionsFieldItemTableRow } from '@/settings/logic-functions/components/SettingsLogicFunctionsFieldItemTableRow';
import { Table } from '@/ui/layout/table/components/Table';
import { TableBody } from '@/ui/layout/table/components/TableBody';
import { TableHeader } from '@/ui/layout/table/components/TableHeader';
import { TableRow } from '@/ui/layout/table/components/TableRow';
import styled from '@emotion/styled';
import { SettingsPath } from 'twenty-shared/types';
import { getSettingsPath } from 'twenty-shared/utils';
import { type LogicFunction } from '~/generated-metadata/graphql';
import { useLingui } from '@lingui/react/macro';
import { useParams } from 'react-router-dom';

export const StyledTableRow = styled(TableRow)`
  grid-template-columns: 164px 1fr 96px 32px;
`;

const StyledTableBody = styled(TableBody)`
  border-bottom: 1px solid ${({ theme }) => theme.border.color.light};
`;

export const SettingsLogicFunctionsTable = ({
  logicFunctions,
}: {
  logicFunctions: LogicFunction[];
}) => {
  const { applicationId = '' } = useParams();

  const { t } = useLingui();

  if (logicFunctions.length === 0) {
    return null;
  }

  return (
    <Table>
      <StyledTableRow>
        <TableHeader>{t`Name`}</TableHeader>
        <TableHeader></TableHeader>
        <TableHeader>{t`Runtime`}</TableHeader>
        <TableHeader></TableHeader>
      </StyledTableRow>
      <StyledTableBody>
        {logicFunctions.map((logicFunction: LogicFunction) => (
          <SettingsLogicFunctionsFieldItemTableRow
            key={logicFunction.id}
            logicFunction={logicFunction}
            to={getSettingsPath(SettingsPath.ApplicationLogicFunctionDetail, {
              applicationId,
              logicFunctionId: logicFunction.id,
            })}
          />
        ))}
      </StyledTableBody>
    </Table>
  );
};
