import { DEFAULT_TASK_RECORD_PAGE_LAYOUT_ID } from '@/page-layout/constants/DefaultTaskRecordPageLayoutId';
import { type PageLayout } from '@/page-layout/types/PageLayout';
import {
  PageLayoutTabLayoutMode,
  PageLayoutType,
  WidgetType,
} from '~/generated-metadata/graphql';

export const DEFAULT_TASK_RECORD_PAGE_LAYOUT: PageLayout = {
  __typename: 'PageLayout',
  id: DEFAULT_TASK_RECORD_PAGE_LAYOUT_ID,
  name: 'Default Task Layout',
  type: PageLayoutType.RECORD_PAGE,
  objectMetadataId: null,
  createdAt: new Date().toISOString(),
  updatedAt: new Date().toISOString(),
  deletedAt: null,
  tabs: [
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'task-tab-fields',
      title: 'Home',
      icon: 'IconHome',
      position: 100,
      layoutMode: PageLayoutTabLayoutMode.VERTICAL_LIST,
      pageLayoutId: DEFAULT_TASK_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'task-widget-fields',
          pageLayoutTabId: 'task-tab-fields',
          title: 'Fields',
          type: WidgetType.FIELDS,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 12,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: 'FIELDS',
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
        {
          __typename: 'PageLayoutWidget',
          id: 'task-widget-note',
          pageLayoutTabId: 'task-tab-fields',
          title: 'Note',
          type: WidgetType.FIELD_RICH_TEXT,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 12,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: 'FIELDS',
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
          conditionalDisplay: {
            and: [
              {
                '===': [{ var: 'device' }, 'MOBILE'],
              },
            ],
          },
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'task-tab-note',
      title: 'Note',
      icon: 'IconNotes',
      position: 150,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_TASK_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'task-widget-note',
          pageLayoutTabId: 'task-tab-note',
          title: 'Note',
          type: WidgetType.FIELD_RICH_TEXT,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 12,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: 'FIELDS',
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
          conditionalDisplay: {
            and: [
              {
                '===': [{ var: 'device' }, 'DESKTOP'],
              },
            ],
          },
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'task-tab-timeline',
      title: 'Timeline',
      icon: 'IconTimelineEvent',
      position: 200,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_TASK_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'task-widget-timeline',
          pageLayoutTabId: 'task-tab-timeline',
          title: 'Timeline',
          type: WidgetType.TIMELINE,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: 'FIELDS',
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'task-tab-files',
      title: 'Files',
      icon: 'IconPaperclip',
      position: 300,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_TASK_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'task-widget-files',
          pageLayoutTabId: 'task-tab-files',
          title: 'Files',
          type: WidgetType.FILES,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: 'FIELDS',
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
  ],
};
